"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ValidationStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _wizard_nav = require("../wizard_nav");
var _step_types = require("../step_types");
var _job_creator_context = require("../job_creator_context");
var _ml_api_service = require("../../../../../services/ml_api_service");
var _validate_job = require("../../../../../components/validate_job");
var _new_job = require("../../../../../../../common/constants/new_job");
var _skip_validatoin = require("./skip_validatoin");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const idFilterList = ['job_id_valid', 'job_group_id_valid', 'detectors_function_not_empty', 'success_bucket_span'];
const ValidationStep = ({
  setCurrentStep,
  isCurrentStep
}) => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobValidator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [nextActive, setNextActive] = (0, _react.useState)(false);
  if (jobCreator.type === _new_job.JOB_TYPE.ADVANCED) {
    // for advanced jobs, ignore time range warning as the
    // user hasn't selected a time range.
    idFilterList.push(...['time_range_short', 'success_time_range']);
  }
  function getJobConfig() {
    return {
      ...jobCreator.jobConfig,
      datafeed_config: jobCreator.datafeedConfig
    };
  }
  function getDuration() {
    return {
      start: jobCreator.start,
      end: jobCreator.end
    };
  }
  (0, _react.useEffect)(() => {
    // force basic validation to run
    jobValidator.validate(() => {}, true);
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  // keep a record of the advanced validation in the jobValidator
  function setIsValid(valid) {
    jobValidator.advancedValid = valid;
    setNextActive(valid);
  }
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, isCurrentStep && /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_validate_job.ValidateJob, {
    getJobConfig: getJobConfig,
    getDuration: getDuration,
    ml: _ml_api_service.ml,
    embedded: true,
    setIsValid: setIsValid,
    idFilterList: idFilterList
  }), /*#__PURE__*/_react.default.createElement(_wizard_nav.WizardNav, {
    previous: () => setCurrentStep(_step_types.WIZARD_STEPS.JOB_DETAILS),
    next: () => setCurrentStep(_step_types.WIZARD_STEPS.SUMMARY),
    nextActive: nextActive
  }, /*#__PURE__*/_react.default.createElement(_skip_validatoin.SkipValidationButton, {
    nextActive: nextActive,
    setCurrentStep: setCurrentStep
  }))), isCurrentStep === false && /*#__PURE__*/_react.default.createElement(_react.Fragment, null));
};
exports.ValidationStep = ValidationStep;