"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareDetectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _rare_field = require("../rare_field");
var _job_creator_context = require("../../../job_creator_context");
var _rare_detector = require("../rare_detector");
var _population_field = require("../population_field");
var _detector_description = require("./detector_description");
var _rare_view = require("./rare_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RareDetectors = ({
  setIsValid,
  rareDetectorType,
  setRareDetectorType
}) => {
  const {
    jobCreator: jc,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [detectorValid, setDetectorValid] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    let valid = false;
    if (jobCreator.rareField !== null) {
      if (rareDetectorType === _rare_view.RARE_DETECTOR_TYPE.RARE) {
        // Rare only requires a rare field to be set
        valid = true;
      } else if (jobCreator.populationField !== null) {
        // all others need a need the population field to be set
        valid = true;
      }
    }
    setIsValid(valid);
    setDetectorValid(valid);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_rare_detector.RareDetector, {
    onChange: setRareDetectorType
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_rare_field.RareFieldSelector, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, rareDetectorType !== _rare_view.RARE_DETECTOR_TYPE.RARE && /*#__PURE__*/_react.default.createElement(_population_field.PopulationFieldSelector, null))), detectorValid && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_detector_description.DetectorDescription, {
    detectorType: rareDetectorType
  }))));
};
exports.RareDetectors = RareDetectors;