"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareFieldSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rare_field_select = require("./rare_field_select");
var _job_creator_context = require("../../../job_creator_context");
var _fields_utils = require("../../../../../../../../../common/util/fields_utils");
var _new_job_capabilities_service = require("../../../../../../../services/new_job_capabilities/new_job_capabilities_service");
var _description = require("./description");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RareFieldSelector = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const runtimeCategoryFields = (0, _react.useMemo)(() => (0, _fields_utils.filterCategoryFields)(jobCreator.runtimeFields), []);
  const allCategoryFields = (0, _react.useMemo)(() => [..._new_job_capabilities_service.newJobCapsService.categoryFields, ...runtimeCategoryFields].sort((a, b) => a.name.localeCompare(b.name)),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const categoryFields = useFilteredCategoryFields(allCategoryFields, jobCreator, jobCreatorUpdated);
  const [rareField, setRareField] = (0, _react.useState)(jobCreator.rareField);
  (0, _react.useEffect)(() => {
    jobCreator.setRareField(rareField);
    // add the split field to the influencers
    if (rareField !== null && jobCreator.influencers.includes(rareField.name) === false) {
      jobCreator.addInfluencer(rareField.name);
    }
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [rareField]);
  (0, _react.useEffect)(() => {
    setRareField(jobCreator.rareField);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_rare_field_select.RareFieldSelect, {
    fields: categoryFields,
    changeHandler: setRareField,
    selectedField: rareField,
    testSubject: "mlRareFieldSelect"
  }));
};

// remove the rare (by) field from the by field options in the rare wizard
exports.RareFieldSelector = RareFieldSelector;
function useFilteredCategoryFields(allCategoryFields, jobCreator, jobCreatorUpdated) {
  const [fields, setFields] = (0, _react.useState)(allCategoryFields);
  (0, _react.useEffect)(() => {
    const pf = jobCreator.populationField;
    const sf = jobCreator.splitField;
    if (pf !== null || sf !== null) {
      setFields(allCategoryFields.filter(({
        name
      }) => name !== (pf === null || pf === void 0 ? void 0 : pf.name) && name !== (sf === null || sf === void 0 ? void 0 : sf.name)));
    } else {
      setFields(allCategoryFields);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return fields;
}