"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BucketSpan = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _bucket_span_input = require("./bucket_span_input");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
var _bucket_span_estimator = require("../bucket_span_estimator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BucketSpan = ({
  setIsValid,
  hideEstimateButton = false
}) => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [bucketSpan, setBucketSpan] = (0, _react.useState)(jobCreator.bucketSpan);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.bucketSpan);
  const [estimating, setEstimating] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    jobCreator.bucketSpan = bucketSpan;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [bucketSpan]);
  (0, _react.useEffect)(() => {
    setBucketSpan(jobCreator.bucketSpan);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.bucketSpan);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  (0, _react.useEffect)(() => {
    setIsValid(estimating === false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [estimating]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_bucket_span_input.BucketSpanInput, {
    setBucketSpan: setBucketSpan
    // @ts-expect-error bucketSpan is of type `estypes.Duration`
    ,
    bucketSpan: bucketSpan,
    isInvalid: validation.valid === false,
    disabled: estimating
  })), hideEstimateButton === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_bucket_span_estimator.BucketSpanEstimator, {
    setEstimating: setEstimating
  }))));
};
exports.BucketSpan = BucketSpan;