"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggSelect = void 0;
exports.createLabel = createLabel;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _field_stats_info_button = require("../../../../../../../components/field_stats_flyout/field_stats_info_button");
var _job_creator_context = require("../../../job_creator_context");
var _use_field_stats_trigger = require("../../../../../../../components/field_stats_flyout/use_field_stats_trigger");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AggSelect = ({
  fields,
  changeHandler,
  selectedOptions,
  removeOptions
}) => {
  const {
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.duplicateDetectors);
  // create list of labels based on already selected detectors
  // so they can be removed from the dropdown list
  const removeLabels = removeOptions.map(createLabel);
  const {
    handleFieldStatsButtonClick
  } = (0, _use_field_stats_trigger.useFieldStatsTrigger)();
  const options = (0, _react.useMemo)(() => fields.map(f => {
    const aggOption = {
      isGroupLabelOption: true,
      key: f.name,
      // @ts-ignore Purposefully passing label as element instead of string
      // for more robust rendering
      label: /*#__PURE__*/_react.default.createElement(_field_stats_info_button.FieldStatsInfoButton, {
        field: f,
        label: f.name,
        onButtonClick: handleFieldStatsButtonClick
      }),
      options: []
    };
    if (typeof f.aggs !== 'undefined') {
      aggOption.options = f.aggs.filter(a => a.dslName !== null) // don't include aggs which have no ES equivalent
      .map(a => ({
        label: `${a.title}(${f.name})`,
        agg: a,
        field: f
      })).filter(o => removeLabels.includes(o.label) === false);
    }
    return aggOption;
  }), [handleFieldStatsButtonClick, fields, removeLabels]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.duplicateDetectors);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    error: validation.message,
    isInvalid: validation.valid === false,
    "data-test-subj": "mlJobWizardAggSelection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    singleSelection: {
      asPlainText: true
    },
    options: options,
    selectedOptions: selectedOptions,
    onChange: changeHandler,
    isClearable: false,
    isInvalid: validation.valid === false
  }));
};
exports.AggSelect = AggSelect;
function createLabel(pair) {
  return `${pair.agg.title}(${pair.field.name})`;
}