"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationsSwitch = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _job_creator_context = require("../../../../../job_creator_context");
var _description = require("./description");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AnnotationsSwitch = () => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [annotationsEnabled, setAnnotationsEnabled] = (0, _react.useState)(jobCreator.modelChangeAnnotations);
  const [showCallOut, setShowCallout] = (0, _react.useState)(jobCreator.modelPlot && !jobCreator.modelChangeAnnotations);
  (0, _react.useEffect)(() => {
    jobCreator.modelChangeAnnotations = annotationsEnabled;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [annotationsEnabled]);
  (0, _react.useEffect)(() => {
    setShowCallout(jobCreator.modelPlot && !annotationsEnabled);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated, annotationsEnabled]);
  function toggleAnnotations() {
    setAnnotationsEnabled(!annotationsEnabled);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_description.Description, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "switch",
    checked: annotationsEnabled,
    onChange: toggleAnnotations,
    "data-test-subj": "mlJobWizardSwitchAnnotations",
    label: _i18n.i18n.translate('xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.enableModelPlotAnnotations.title', {
      defaultMessage: 'Enable model change annotations'
    })
  })), showCallOut && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.jobDetailsStep.advancedSection.annotationsSwitchCallout.title",
      defaultMessage: "If you enable model plot with this configuration, we recommend you also enable annotations."
    }),
    color: "primary",
    iconType: "help"
  }));
};
exports.AnnotationsSwitch = AnnotationsSwitch;