"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJobsItemsFromEmbeddable = getJobsItemsFromEmbeddable;
exports.isCompatibleMapVisualization = isCompatibleMapVisualization;
exports.redirectToGeoJobWizard = redirectToGeoJobWizard;
var _i18n = require("@kbn/i18n");
var _locator = require("../../../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function redirectToGeoJobWizard(embeddable, dataViewId, geoField, layerQuery, splitField, share) {
  const {
    query,
    filters,
    to,
    from
  } = await getJobsItemsFromEmbeddable(embeddable);
  const embeddableQuery = await embeddable.getQuery();
  const embeddableFilters = await embeddable.getFilters();
  const locator = share.url.locators.get(_locator.ML_APP_LOCATOR);
  const pageState = {
    dashboard: {
      query,
      filters
    },
    dataViewId,
    embeddable: {
      query: embeddableQuery,
      filters: embeddableFilters
    },
    geoField,
    splitField,
    from,
    to,
    ...(layerQuery ? {
      layer: {
        query: layerQuery
      }
    } : {})
  };
  const url = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
    page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_FROM_MAP,
    pageState
  }));
  window.open(url, '_blank');
}
function isCompatibleMapVisualization(embeddable) {
  return embeddable.getLayerList().some(layer => {
    const geoField = layer.getGeoFieldNames().length ? layer.getGeoFieldNames()[0] : undefined;
    const dataViewId = layer.getIndexPatternIds().length ? layer.getIndexPatternIds()[0] : undefined;
    return geoField && dataViewId;
  });
}
async function getJobsItemsFromEmbeddable(embeddable) {
  var _embeddable$parent;
  // Get dashboard level query/filters
  const {
    filters,
    timeRange,
    ...input
  } = embeddable.getInput();
  const query = input.query === undefined ? {
    query: '',
    language: 'kuery'
  } : input.query;
  if (timeRange === undefined) {
    throw Error(_i18n.i18n.translate('xpack.ml.newJob.fromGeo.createJob.error.noTimeRange', {
      defaultMessage: 'Time range not specified.'
    }));
  }
  const {
    to,
    from
  } = timeRange;
  const dashboard = ((_embeddable$parent = embeddable.parent) === null || _embeddable$parent === void 0 ? void 0 : _embeddable$parent.type) === 'dashboard' ? embeddable.parent : undefined;
  return {
    from,
    to,
    query,
    filters,
    dashboard
  };
}