"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolver = resolver;
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _quick_create_job = require("./quick_create_job");
var _new_job_utils = require("../utils/new_job_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function resolver(deps, lensSavedObjectRisonString, fromRisonStrong, toRisonStrong, queryRisonString, filtersRisonString, layerIndexRisonString) {
  const {
    lens,
    mlApiServices,
    timeFilter,
    kibanaConfig,
    share
  } = deps;
  if (lensSavedObjectRisonString === undefined) {
    throw new Error('Cannot create visualization');
  }
  const vis = _rison.default.decode(lensSavedObjectRisonString);
  if (!vis) {
    throw new Error('Cannot create visualization');
  }
  let query;
  let filters;
  try {
    query = _rison.default.decode(queryRisonString);
  } catch (error) {
    query = (0, _new_job_utils.getDefaultQuery)();
  }
  try {
    filters = _rison.default.decode(filtersRisonString);
  } catch (error) {
    filters = [];
  }
  let from;
  let to;
  try {
    from = _rison.default.decode(fromRisonStrong);
  } catch (error) {
    from = '';
  }
  try {
    to = _rison.default.decode(toRisonStrong);
  } catch (error) {
    to = '';
  }
  let layerIndex;
  try {
    layerIndex = _rison.default.decode(layerIndexRisonString);
  } catch (error) {
    layerIndex = undefined;
  }
  const jobCreator = new _quick_create_job.QuickLensJobCreator(lens, kibanaConfig, timeFilter, share, mlApiServices);
  await jobCreator.createAndStashADJob(vis, from, to, query, filters, layerIndex);
}