"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedJobCreator = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _job_creator = require("./job_creator");
var _default_configs = require("./util/default_configs");
var _new_job = require("../../../../../../common/constants/new_job");
var _general = require("./util/general");
var _validation_utils = require("../../../../../../common/util/validation_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class AdvancedJobCreator extends _job_creator.JobCreator {
  constructor(indexPattern, savedSearch, query) {
    super(indexPattern, savedSearch, query);
    (0, _defineProperty2.default)(this, "_type", _new_job.JOB_TYPE.ADVANCED);
    (0, _defineProperty2.default)(this, "_richDetectors", []);
    (0, _defineProperty2.default)(this, "_queryString", void 0);
    this._queryString = JSON.stringify(this._datafeed_config.query);
    this._wizardInitialized$.next(true);
  }
  addDetector(agg, field, byField, overField, partitionField, excludeFrequent, description, useNull) {
    // addDetector doesn't support adding new custom rules.
    // this will be added in the future once it's supported in the UI
    const customRules = null;
    const {
      detector,
      richDetector
    } = this._createDetector(agg, field, byField, overField, partitionField, excludeFrequent, description, customRules, useNull);
    this._addDetector(detector, agg, field);
    this._richDetectors.push(richDetector);
  }
  editDetector(agg, field, byField, overField, partitionField, excludeFrequent, description, index, useNull) {
    const customRules = this._detectors[index] !== undefined ? this._detectors[index].custom_rules || null : null;
    const {
      detector,
      richDetector
    } = this._createDetector(agg, field, byField, overField, partitionField, excludeFrequent, description, customRules, useNull);
    this._editDetector(detector, agg, field, index);
    if (this._richDetectors[index] !== undefined) {
      this._richDetectors[index] = richDetector;
    }
  }
  _createDetector(agg, field, byField, overField, partitionField, excludeFrequent, description, customRules, useNull) {
    const detector = (0, _default_configs.createBasicDetector)(agg, field);
    if (byField !== null) {
      detector.by_field_name = byField.id;
    }
    if (overField !== null) {
      detector.over_field_name = overField.id;
    }
    if (partitionField !== null) {
      detector.partition_field_name = partitionField.id;
    }
    if (excludeFrequent !== null) {
      detector.exclude_frequent = excludeFrequent;
    }
    if (description !== null) {
      detector.detector_description = description;
    }
    if (customRules !== null) {
      detector.custom_rules = customRules;
    }
    if (useNull !== null) {
      detector.use_null = useNull;
    }
    const richDetector = {
      agg,
      field,
      byField,
      overField,
      partitionField,
      excludeFrequent,
      description,
      customRules,
      useNull
    };
    return {
      detector,
      richDetector
    };
  }
  removeDetector(index) {
    this._removeDetector(index);
    this._richDetectors.splice(index, 1);
  }
  get richDetectors() {
    return this._richDetectors;
  }
  get queryString() {
    return this._queryString;
  }
  set queryString(qs) {
    this._queryString = qs;
  }
  get isValidQueryString() {
    return (0, _validation_utils.isValidJson)(this._queryString);
  }
  cloneFromExistingJob(job, datafeed) {
    this._overrideConfigs(job, datafeed);
    const detectors = (0, _general.getRichDetectors)(job, datafeed, this.additionalFields, true);

    // keep track of the custom rules for each detector
    const customRules = this._detectors.map(d => d.custom_rules);
    this.removeAllDetectors();
    this._richDetectors.length = 0;
    detectors.forEach((d, i) => {
      const dtr = detectors[i];
      if (dtr.agg !== null && dtr.field !== null) {
        this.addDetector(dtr.agg, dtr.field, dtr.byField, dtr.overField, dtr.partitionField, dtr.excludeFrequent, dtr.description, dtr.useNull);
      }
    });

    // re-apply custom rules
    customRules.forEach((cr, i) => {
      if (cr !== undefined) {
        this._detectors[i].custom_rules = cr;
      }
    });
  }
}
exports.AdvancedJobCreator = AdvancedJobCreator;