"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddAnomalyChartsToDashboardControl = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _mlIsDefined = require("@kbn/ml-is-defined");
var _explorer_utils = require("../explorer_utils");
var _anomaly_explorer_context = require("../anomaly_explorer_context");
var _string_utils = require("../../util/string_utils");
var _search = require("../../../../common/constants/search");
var _use_dashboards_table = require("./use_dashboards_table");
var _add_to_dashboard_controls = require("./add_to_dashboard_controls");
var _use_add_to_dashboard_actions = require("./use_add_to_dashboard_actions");
var _anomaly_explorer_charts_service = require("../../services/anomaly_explorer_charts_service");
var _embeddables = require("../../../embeddables");
var _anomaly_charts_embeddable = require("../../../embeddables/anomaly_charts/anomaly_charts_embeddable");
var _select_severity = require("../../components/controls/select_severity");
var _anomaly_charts_initializer = require("../../../embeddables/anomaly_charts/anomaly_charts_initializer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDefaultEmbeddablePanelConfig(jobIds, queryString) {
  return {
    id: (0, _eui.htmlIdGenerator)()(),
    title: (0, _anomaly_charts_embeddable.getDefaultExplorerChartsPanelTitle)(jobIds).concat(queryString ? `- ${queryString}` : '')
  };
}
/**
 * Component for attaching anomaly swim lane embeddable to dashboards.
 */
const AddAnomalyChartsToDashboardControl = ({
  onClose,
  jobIds
}) => {
  const [severity] = (0, _select_severity.useTableSeverity)();
  const [maxSeriesToPlot, setMaxSeriesToPlot] = (0, _react.useState)(_anomaly_explorer_charts_service.DEFAULT_MAX_SERIES_TO_PLOT);
  const {
    anomalyExplorerCommonStateService,
    anomalyTimelineStateService
  } = (0, _anomaly_explorer_context.useAnomalyExplorerContext)();
  const {
    queryString
  } = (0, _useObservable.default)(anomalyExplorerCommonStateService.getFilterSettings$(), anomalyExplorerCommonStateService.getFilterSettings());
  const selectedCells = (0, _useObservable.default)(anomalyTimelineStateService.getSelectedCells$(), anomalyTimelineStateService.getSelectedCells());
  const getEmbeddableInput = (0, _react.useCallback)(() => {
    // Respect the query and the influencers selected
    // If no query or filter set, filter out to the lanes the selected cells
    // And if no selected cells, show everything

    const selectionInfluencers = (0, _explorer_utils.getSelectionInfluencers)(selectedCells, selectedCells === null || selectedCells === void 0 ? void 0 : selectedCells.viewByFieldName);
    const influencers = selectionInfluencers !== null && selectionInfluencers !== void 0 ? selectionInfluencers : [];
    const config = getDefaultEmbeddablePanelConfig(jobIds, queryString);
    const queryFromSelectedCells = influencers.map(s => (0, _string_utils.escapeKueryForFieldValuePair)(s.fieldName, s.fieldValue)).join(' or ');

    // When adding anomaly charts to Dashboard, we want to respect the Dashboard's time range
    // so we are not passing the time range here
    return {
      ...config,
      jobIds,
      maxSeriesToPlot: maxSeriesToPlot !== null && maxSeriesToPlot !== void 0 ? maxSeriesToPlot : _anomaly_explorer_charts_service.DEFAULT_MAX_SERIES_TO_PLOT,
      severityThreshold: severity.val,
      ...((0, _mlIsDefined.isDefined)(queryString) && queryString !== '' || queryFromSelectedCells !== undefined && queryFromSelectedCells !== '' ? {
        query: {
          query: queryString === '' ? queryFromSelectedCells : queryString,
          language: _search.SEARCH_QUERY_LANGUAGE.KUERY
        }
      } : {})
    };
  }, [jobIds, maxSeriesToPlot, severity, queryString, selectedCells]);
  const {
    dashboardItems,
    isLoading,
    search
  } = (0, _use_dashboards_table.useDashboardTable)();
  const {
    addToDashboardAndEditCallback
  } = (0, _use_add_to_dashboard_actions.useAddToDashboardActions)(_embeddables.ANOMALY_EXPLORER_CHARTS_EMBEDDABLE_TYPE, getEmbeddableInput);
  const title = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.explorer.addToDashboard.anomalyCharts.dashboardsTitle",
    defaultMessage: "Add anomaly charts to dashboards"
  });
  const isMaxSeriesToPlotValid = maxSeriesToPlot >= 1 && maxSeriesToPlot <= _anomaly_charts_initializer.MAX_ANOMALY_CHARTS_ALLOWED;
  const extraControls = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !isMaxSeriesToPlotValid,
    error: !isMaxSeriesToPlotValid ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.anomalyChartsEmbeddable.maxSeriesToPlotError",
      defaultMessage: "Maximum number of series to plot must be between 1 and 50."
    }) : undefined,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.explorer.addToDashboard.anomalyCharts.maxSeriesToPlotLabel",
      defaultMessage: "Maximum number of series to plot"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "mlAnomalyChartsInitializerMaxSeries",
    id: "selectMaxSeriesToPlot",
    name: "selectMaxSeriesToPlot",
    value: maxSeriesToPlot,
    onChange: e => setMaxSeriesToPlot(parseInt(e.target.value, 10)),
    min: 1,
    max: _anomaly_charts_initializer.MAX_ANOMALY_CHARTS_ALLOWED
  }));
  return /*#__PURE__*/_react.default.createElement(_add_to_dashboard_controls.AddToDashboardControl, {
    onClose: onClose,
    dashboardItems: dashboardItems,
    isLoading: isLoading,
    search: search,
    addToDashboardAndEditCallback: addToDashboardAndEditCallback,
    disabled: !isMaxSeriesToPlotValid,
    title: title
  }, extraControls);
};
exports.AddAnomalyChartsToDashboardControl = AddAnomalyChartsToDashboardControl;