"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceSelection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlNestedProperty = require("@kbn/ml-nested-property");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _kibana = require("../../../../../contexts/kibana");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
var _index_utils = require("../../../../../util/index_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fixedPageSize = 20;
const SourceSelection = () => {
  const {
    services: {
      http,
      uiSettings,
      savedObjectsManagement,
      savedSearch: savedSearchService,
      data: {
        dataViews: dataViewsService
      }
    }
  } = (0, _kibana.useMlKibana)();
  const navigateToPath = (0, _kibana.useNavigateToPath)();
  const [isCcsCallOut, setIsCcsCallOut] = (0, _react.useState)(false);
  const [ccsCallOutBodyText, setCcsCallOutBodyText] = (0, _react.useState)();
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const onSearchSelected = async (id, type, fullName, savedObject) => {
    // Kibana data views including `:` are cross-cluster search indices
    // and are not supported by Data Frame Analytics yet. For saved searches
    // and data views that use cross-cluster search we intercept
    // the selection before redirecting and show an error callout instead.
    let dataViewName = '';
    if (type === 'index-pattern') {
      dataViewName = (0, _mlNestedProperty.getNestedProperty)(savedObject, 'attributes.title');
    } else if (type === 'search') {
      try {
        var _dataViewAndSavedSear, _dataViewAndSavedSear2;
        const dataViewAndSavedSearch = await (0, _index_utils.getDataViewAndSavedSearchCallback)({
          savedSearchService,
          dataViewsService
        })(id);
        dataViewName = (_dataViewAndSavedSear = (_dataViewAndSavedSear2 = dataViewAndSavedSearch.dataView) === null || _dataViewAndSavedSear2 === void 0 ? void 0 : _dataViewAndSavedSear2.title) !== null && _dataViewAndSavedSear !== void 0 ? _dataViewAndSavedSear : '';
      } catch (error) {
        // an unexpected error has occurred. This could be caused by a saved search for which the data view no longer exists.
        toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.errorGettingDataViewTitle', {
          defaultMessage: 'Error loading data view used by the saved search'
        }));
        return;
      }
    }
    if ((0, _index_utils.isCcsIndexPattern)(dataViewName)) {
      setIsCcsCallOut(true);
      if (type === 'search') {
        setCcsCallOutBodyText(_i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.CcsErrorCallOutBody', {
          defaultMessage: `The saved search '{savedSearchTitle}' uses the data view '{dataViewName}'.`,
          values: {
            savedSearchTitle: (0, _mlNestedProperty.getNestedProperty)(savedObject, 'attributes.title'),
            dataViewName
          }
        }));
      } else {
        setCcsCallOutBodyText(undefined);
      }
      return;
    }
    await navigateToPath(`/data_frame_analytics/new_job?${type === 'index-pattern' ? 'index' : 'savedSearchId'}=${encodeURIComponent(id)}`);
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlDFAPageSourceSelection"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageContent_Deprecated, {
    hasShadow: false,
    hasBorder: true
  }, isCcsCallOut && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "analyticsCreateSourceIndexModalCcsErrorCallOut",
    title: _i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.CcsErrorCallOutTitle', {
      defaultMessage: 'Data views using cross-cluster search are not supported.'
    }),
    color: "danger"
  }, typeof ccsCallOutBodyText === 'string' && /*#__PURE__*/_react.default.createElement("p", null, ccsCallOutBodyText)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    key: "searchSavedObjectFinder",
    onChoose: onSearchSelected,
    showFilter: true,
    noItemsMessage: _i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.notFoundLabel', {
      defaultMessage: 'No matching indices or saved searches found.'
    }),
    savedObjectMetaData: [{
      type: 'search',
      getIconForSavedObject: () => 'search',
      name: _i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.savedObjectType.search', {
        defaultMessage: 'Saved search'
      })
    }, {
      type: 'index-pattern',
      getIconForSavedObject: () => 'indexPatternApp',
      name: _i18n.i18n.translate('xpack.ml.dataFrame.analytics.create.searchSelection.savedObjectType.indexPattern', {
        defaultMessage: 'Data view'
      }),
      defaultSearchField: 'name'
    }],
    fixedPageSize: fixedPageSize,
    services: {
      uiSettings,
      http,
      savedObjectsManagement
    }
  }))));
};
exports.SourceSelection = SourceSelection;