"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProgressBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProgressBar = ({
  progress
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "xs"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  style: {
    width: '100px'
  },
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
  value: progress,
  max: 100,
  color: "primary",
  size: "m"
}, progress, "%")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  style: {
    width: '35px'
  },
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, `${progress}%`)));
exports.ProgressBar = ProgressBar;