"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDeleteAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _kibana = require("../../../../../contexts/kibana");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
var _analytics_service = require("../../services/analytics_service");
var _common = require("../analytics_list/common");
var _delete_action_name = require("./delete_action_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DF_ANALYTICS_JOB_TYPE = 'data-frame-analytics';
const useDeleteAction = canDeleteDataFrameAnalytics => {
  var _item$config$dest$ind;
  const [item, setItem] = (0, _react.useState)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [isDeleteJobCheckModalVisible, setDeleteJobCheckModalVisible] = (0, _react.useState)(false);
  const [deleteItem, setDeleteItem] = (0, _react.useState)(false);
  const [deleteTargetIndex, setDeleteTargetIndex] = (0, _react.useState)(true);
  const [deleteIndexPattern, setDeleteIndexPattern] = (0, _react.useState)(true);
  const [userCanDeleteIndex, setUserCanDeleteIndex] = (0, _react.useState)(false);
  const [userCanDeleteDataView, setUserCanDeleteDataView] = (0, _react.useState)(false);
  const [indexPatternExists, setIndexPatternExists] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    data: {
      dataViews
    },
    application: {
      capabilities
    }
  } = (0, _kibana.useMlKibana)().services;
  const indexName = (_item$config$dest$ind = item === null || item === void 0 ? void 0 : item.config.dest.index) !== null && _item$config$dest$ind !== void 0 ? _item$config$dest$ind : '';
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const checkIndexPatternExists = async () => {
    try {
      const dv = (await dataViews.getIdsWithTitle()).find(({
        title
      }) => title === indexName);
      if (dv !== undefined) {
        setIndexPatternExists(true);
      } else {
        setIndexPatternExists(false);
      }
      setIsLoading(false);
    } catch (e) {
      const error = (0, _mlErrorUtils.extractErrorMessage)(e);
      setIsLoading(false);
      toastNotificationService.displayDangerToast(_i18n.i18n.translate('xpack.ml.dataframe.analyticsList.errorWithCheckingIfDataViewExistsNotificationErrorMessage', {
        defaultMessage: 'An error occurred checking if data view {dataView} exists: {error}',
        values: {
          dataView: indexName,
          error
        }
      }));
    }
  };
  const checkUserIndexPermission = async () => {
    try {
      const userCanDelete = await (0, _analytics_service.canDeleteIndex)(indexName, toastNotificationService);
      if (userCanDelete) {
        setUserCanDeleteIndex(true);
      }
      const canDeleteDataView = capabilities.savedObjectsManagement.delete === true || capabilities.indexPatterns.save === true;
      setUserCanDeleteDataView(canDeleteDataView);
      if (canDeleteDataView === false) {
        setDeleteIndexPattern(false);
      }
    } catch (e) {
      const error = (0, _mlErrorUtils.extractErrorMessage)(e);
      setIsLoading(false);
      toastNotificationService.displayDangerToast(_i18n.i18n.translate('xpack.ml.dataframe.analyticsList.errorWithCheckingIfUserCanDeleteIndexNotificationErrorMessage', {
        defaultMessage: 'An error occurred checking if user can delete {destinationIndex}: {error}',
        values: {
          destinationIndex: indexName,
          error
        }
      }));
    }
  };
  (0, _react.useEffect)(() => {
    setIsLoading(true);
    // Check if a data view exists corresponding to current DFA job
    // if data view does exist, show it to user
    checkIndexPatternExists();
    // Check if an user has permission to delete the index & data view
    checkUserIndexPermission();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [isModalVisible]);
  const closeModal = () => setModalVisible(false);
  const closeDeleteJobCheckModal = () => setDeleteJobCheckModalVisible(false);
  const deleteAndCloseModal = () => {
    setDeleteItem(true);
    setModalVisible(false);
    if (item !== undefined) {
      if (userCanDeleteIndex && deleteTargetIndex || userCanDeleteIndex && deleteIndexPattern) {
        (0, _analytics_service.deleteAnalyticsAndDestIndex)(item.config, item.stats, deleteTargetIndex, indexPatternExists && deleteIndexPattern, toastNotificationService);
      } else {
        (0, _analytics_service.deleteAnalytics)(item.config, item.stats, toastNotificationService);
      }
    }
  };
  const toggleDeleteIndex = () => setDeleteTargetIndex(!deleteTargetIndex);
  const toggleDeleteIndexPattern = () => setDeleteIndexPattern(!deleteIndexPattern);
  const openModal = newItem => {
    setItem(newItem);
    setModalVisible(true);
  };
  const openDeleteJobCheckModal = newItem => {
    setItem(newItem);
    setDeleteJobCheckModalVisible(true);
  };
  const action = (0, _react.useMemo)(() => ({
    name: i => /*#__PURE__*/_react.default.createElement(_delete_action_name.DeleteActionName, {
      isDisabled: (0, _common.isDataFrameAnalyticsRunning)(i.stats.state) || !canDeleteDataFrameAnalytics,
      item: i
    }),
    enabled: i => !(0, _common.isDataFrameAnalyticsRunning)(i.stats.state) && canDeleteDataFrameAnalytics,
    description: _delete_action_name.deleteActionNameText,
    icon: 'trash',
    type: 'icon',
    onClick: i => openDeleteJobCheckModal(i),
    'data-test-subj': 'mlAnalyticsJobDeleteButton'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  return {
    action,
    closeDeleteJobCheckModal,
    closeModal,
    deleteAndCloseModal,
    deleteTargetIndex,
    deleteIndexPattern,
    deleteItem,
    indexPatternExists,
    isDeleteJobCheckModalVisible,
    isModalVisible,
    isLoading,
    item,
    jobType: DF_ANALYTICS_JOB_TYPE,
    openModal,
    openDeleteJobCheckModal,
    toggleDeleteIndex,
    toggleDeleteIndexPattern,
    userCanDeleteIndex,
    userCanDeleteDataView
  };
};
exports.useDeleteAction = useDeleteAction;