"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = exports.ANALYTICS_STEPS = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _data_source_context = require("../../../contexts/ml/data_source_context");
var _ml_api_service = require("../../../services/ml_api_service");
var _use_create_analytics_form = require("../analytics_management/hooks/use_create_analytics_form");
var _create_analytics_advanced_editor = require("./components/create_analytics_advanced_editor");
var _components = require("./components");
var _page_header = require("../../../components/page_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ANALYTICS_STEPS;
exports.ANALYTICS_STEPS = ANALYTICS_STEPS;
(function (ANALYTICS_STEPS) {
  ANALYTICS_STEPS[ANALYTICS_STEPS["CONFIGURATION"] = 0] = "CONFIGURATION";
  ANALYTICS_STEPS[ANALYTICS_STEPS["ADVANCED"] = 1] = "ADVANCED";
  ANALYTICS_STEPS[ANALYTICS_STEPS["DETAILS"] = 2] = "DETAILS";
  ANALYTICS_STEPS[ANALYTICS_STEPS["VALIDATION"] = 3] = "VALIDATION";
  ANALYTICS_STEPS[ANALYTICS_STEPS["CREATE"] = 4] = "CREATE";
})(ANALYTICS_STEPS || (exports.ANALYTICS_STEPS = ANALYTICS_STEPS = {}));
const Page = ({
  jobId
}) => {
  const [currentStep, setCurrentStep] = (0, _react.useState)(ANALYTICS_STEPS.CONFIGURATION);
  const [activatedSteps, setActivatedSteps] = (0, _react.useState)([true, false, false, false, false]);
  const {
    selectedDataView
  } = (0, _data_source_context.useDataSource)();
  const createAnalyticsForm = (0, _use_create_analytics_form.useCreateAnalyticsForm)();
  const {
    state
  } = createAnalyticsForm;
  const {
    isAdvancedEditorEnabled,
    disableSwitchToForm,
    isJobCreated
  } = state;
  const {
    jobType
  } = state.form;
  const {
    initiateWizard,
    setJobClone,
    switchToAdvancedEditor,
    switchToForm
  } = createAnalyticsForm.actions;
  (0, _react.useEffect)(() => {
    initiateWizard();
    if (selectedDataView) {
      (async function () {
        if (jobId !== undefined) {
          const analyticsConfigs = await _ml_api_service.ml.dataFrameAnalytics.getDataFrameAnalytics(jobId, true);
          if (Array.isArray(analyticsConfigs.data_frame_analytics) && analyticsConfigs.data_frame_analytics.length > 0) {
            const clonedJobConfig = analyticsConfigs.data_frame_analytics[0];
            await setJobClone(clonedJobConfig);
          }
        }
      })();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    if (activatedSteps[currentStep] === false) {
      activatedSteps.splice(currentStep, 1, true);
      setActivatedSteps(activatedSteps);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [currentStep]);
  const analyticsWizardSteps = [{
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.creation.configurationStepTitle', {
      defaultMessage: 'Configuration'
    }),
    children: /*#__PURE__*/_react.default.createElement(_components.ConfigurationStep, (0, _extends2.default)({}, createAnalyticsForm, {
      isClone: jobId !== undefined,
      setCurrentStep: setCurrentStep,
      step: currentStep,
      stepActivated: activatedSteps[ANALYTICS_STEPS.CONFIGURATION]
    })),
    status: currentStep >= ANALYTICS_STEPS.CONFIGURATION ? undefined : 'incomplete'
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.creation.advancedStepTitle', {
      defaultMessage: 'Additional options'
    }),
    children: /*#__PURE__*/_react.default.createElement(_components.AdvancedStep, (0, _extends2.default)({}, createAnalyticsForm, {
      setCurrentStep: setCurrentStep,
      step: currentStep,
      stepActivated: activatedSteps[ANALYTICS_STEPS.ADVANCED]
    })),
    status: currentStep >= ANALYTICS_STEPS.ADVANCED ? undefined : 'incomplete'
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.creation.detailsStepTitle', {
      defaultMessage: 'Job details'
    }),
    children: /*#__PURE__*/_react.default.createElement(_components.DetailsStep, (0, _extends2.default)({}, createAnalyticsForm, {
      setCurrentStep: setCurrentStep,
      step: currentStep,
      stepActivated: activatedSteps[ANALYTICS_STEPS.DETAILS]
    })),
    status: currentStep >= ANALYTICS_STEPS.DETAILS ? undefined : 'incomplete'
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.creation.validationStepTitle', {
      defaultMessage: 'Validation'
    }),
    children: /*#__PURE__*/_react.default.createElement(_components.ValidationStepWrapper, (0, _extends2.default)({}, createAnalyticsForm, {
      setCurrentStep: setCurrentStep,
      step: currentStep,
      stepActivated: activatedSteps[ANALYTICS_STEPS.VALIDATION]
    })),
    status: currentStep >= ANALYTICS_STEPS.VALIDATION ? undefined : 'incomplete'
  }, {
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.creation.createStepTitle', {
      defaultMessage: 'Create'
    }),
    children: /*#__PURE__*/_react.default.createElement(_components.CreateStep, (0, _extends2.default)({}, createAnalyticsForm, {
      step: currentStep
    })),
    status: currentStep >= ANALYTICS_STEPS.CREATE ? undefined : 'incomplete'
  }];
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "mlAnalyticsCreationContainer"
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "mlDataFrameAnalyticsWizardHeaderTitle"
  }, jobId === undefined && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.creationPageTitle",
    defaultMessage: "Create job"
  }), jobId !== undefined && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.clone.creationPageTitle",
    defaultMessage: "Clone job from {jobId}",
    values: {
      jobId
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    restrictWidth: 1200
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.dataframe.analytics.creationPageSourceIndexTitle",
    defaultMessage: "Source data view: {dataViewTitle}",
    values: {
      dataViewTitle: selectedDataView.title
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    helpText: disableSwitchToForm && _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.jsonEditorDisabledSwitchText', {
      defaultMessage: 'Configuration contains advanced fields not supported by the form. You cannot switch back to the form.'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: jobType === undefined || disableSwitchToForm || isJobCreated,
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.switchToJsonEditorSwitch', {
      defaultMessage: 'Switch to json editor'
    }),
    checked: isAdvancedEditorEnabled,
    onChange: e => {
      if (e.target.checked === true) {
        switchToAdvancedEditor();
      } else {
        switchToForm();
      }
    },
    "data-test-subj": "mlAnalyticsCreateJobWizardAdvancedEditorSwitch"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), isAdvancedEditorEnabled === true && /*#__PURE__*/_react.default.createElement(_create_analytics_advanced_editor.CreateAnalyticsAdvancedEditor, createAnalyticsForm), isAdvancedEditorEnabled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    "data-test-subj": "mlAnalyticsCreateJobWizardSteps",
    steps: analyticsWizardSteps
  })));
};
exports.Page = Page;