"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobType = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const jobDetails = {
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION]: {
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.outlierDetectionHelpText', {
      defaultMessage: 'Identify unusual data points in the data set.'
    }),
    icon: 'outlierDetectionJob',
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.outlierDetectionTitle', {
      defaultMessage: 'Outlier detection'
    })
  },
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION]: {
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.regressionHelpText', {
      defaultMessage: 'Predict numerical values in the data set.'
    }),
    icon: 'regressionJob',
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.regressionTitle', {
      defaultMessage: 'Regression'
    })
  },
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION]: {
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.classificationHelpText', {
      defaultMessage: 'Predict classes of data points in the data set.'
    }),
    icon: 'classificationJob',
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.classificationTitle', {
      defaultMessage: 'Classification'
    })
  }
};
const JobType = ({
  type,
  setFormState
}) => {
  const [selectedCard, setSelectedCard] = (0, _react.useState)({});
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    "data-test-subj": "mlAnalyticsCreateJobWizardJobTypeSelect"
  }, Object.keys(jobDetails).map(jobType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: jobType,
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: jobDetails[jobType].icon
    }),
    title: jobDetails[jobType].title,
    description: jobDetails[jobType].helpText,
    "data-test-subj": `mlAnalyticsCreation-${jobType}-option${type === jobType ? ' selectedJobType' : ''}`,
    selectable: {
      onClick: () => {
        // Only allow one job selected at a time and don't allow deselection
        if (selectedCard[jobType] === true) {
          return;
        }
        setFormState({
          previousJobType: type,
          jobType,
          requiredFieldsError: undefined
        });
        setSelectedCard({
          [jobType]: !selectedCard[jobType]
        });
      },
      isSelected: selectedCard[jobType] === true || type === jobType
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.JobType = JobType;