"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderCellPopoverFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _mlDataGrid = require("@kbn/ml-data-grid");
var _decision_path_popover = require("../pages/analytics_exploration/components/feature_importance/decision_path_popover");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderCellPopoverFactory = ({
  analysisType,
  baseline,
  data,
  pagination,
  predictionFieldName,
  resultsField
}) => popoverProps => {
  const {
    schema,
    rowIndex,
    cellContentsElement,
    DefaultCellPopover
  } = popoverProps;
  if (analysisType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION || analysisType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION || analysisType === _mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION) {
    if (schema === 'featureImportance') {
      const row = data[rowIndex - pagination.pageIndex * pagination.pageSize];
      if (!row) return /*#__PURE__*/_react.default.createElement("div", null);
      // if resultsField for some reason is not available then use ml
      const mlResultsField = resultsField !== null && resultsField !== void 0 ? resultsField : _mlDataFrameAnalyticsUtils.DEFAULT_RESULTS_FIELD;
      let predictedValue;
      let predictedProbability;
      let topClasses = [];
      if (predictionFieldName !== undefined && row && row[`${mlResultsField}.${predictionFieldName}`] !== undefined) {
        predictedValue = row[`${mlResultsField}.${predictionFieldName}`];
        topClasses = (0, _mlDataGrid.getTopClasses)(row, mlResultsField);
        predictedProbability = row[`${mlResultsField}.prediction_probability`];
      }
      const isClassTypeBoolean = topClasses.reduce((p, c) => typeof c.class_name === 'boolean' || p, false);
      const parsedFIArray = (0, _mlDataGrid.getFeatureImportance)(row, mlResultsField, isClassTypeBoolean);
      return /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "mlDFAFeatureImportancePopover"
      }, /*#__PURE__*/_react.default.createElement(_decision_path_popover.DecisionPathPopover, {
        analysisType: analysisType,
        predictedValue: predictedValue,
        predictedProbability: predictedProbability,
        baseline: baseline,
        featureImportance: parsedFIArray,
        topClasses: topClasses,
        predictionFieldName: predictionFieldName ? predictionFieldName.replace('_prediction', '') : undefined
      }));
    } else if (schema === 'featureInfluence') {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        isCopyable: true
      }, cellContentsElement.textContent);
    } else {
      return /*#__PURE__*/_react.default.createElement(DefaultCellPopover, popoverProps);
    }
  } else {
    return /*#__PURE__*/_react.default.createElement(DefaultCellPopover, popoverProps);
  }
};
exports.renderCellPopoverFactory = renderCellPopoverFactory;