"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionExpression = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _utils = require("./utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering a rule condition numerical expression.
 */

class ConditionExpression extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "openAppliesTo", () => {
      this.setState({
        isAppliesToOpen: true,
        isOperatorValueOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "closeAppliesTo", () => {
      this.setState({
        isAppliesToOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "openOperatorValue", () => {
      this.setState({
        isAppliesToOpen: false,
        isOperatorValueOpen: true
      });
    });
    (0, _defineProperty2.default)(this, "closeOperatorValue", () => {
      this.setState({
        isOperatorValueOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "changeAppliesTo", event => {
      const {
        index,
        operator,
        value,
        updateCondition
      } = this.props;
      updateCondition(index, event.target.value, operator, value);
    });
    (0, _defineProperty2.default)(this, "changeOperator", event => {
      const {
        index,
        appliesTo,
        value,
        updateCondition
      } = this.props;
      updateCondition(index, appliesTo, event.target.value, value);
    });
    (0, _defineProperty2.default)(this, "changeValue", event => {
      const {
        index,
        appliesTo,
        operator,
        updateCondition
      } = this.props;
      updateCondition(index, appliesTo, operator, +event.target.value);
    });
    this.state = {
      isAppliesToOpen: false,
      isOperatorValueOpen: false
    };
  }
  renderAppliesToPopover() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.conditionExpression.appliesToPopoverTitle",
      defaultMessage: "When"
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "euiExpression",
      style: {
        width: 200
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      value: this.props.appliesTo,
      onChange: this.changeAppliesTo,
      options: [{
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.ACTUAL,
        text: (0, _utils.appliesToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.ACTUAL)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.TYPICAL,
        text: (0, _utils.appliesToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.TYPICAL)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.DIFF_FROM_TYPICAL,
        text: (0, _utils.appliesToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.DIFF_FROM_TYPICAL)
      }]
    })));
  }
  renderOperatorValuePopover() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.ruleEditor.conditionExpression.operatorValuePopoverTitle",
      defaultMessage: "Is"
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "euiExpression"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        maxWidth: 450
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        width: 250
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      value: this.props.operator,
      onChange: this.changeOperator,
      options: [{
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN,
        text: (0, _utils.operatorToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN_OR_EQUAL,
        text: (0, _utils.operatorToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN_OR_EQUAL)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN,
        text: (0, _utils.operatorToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN)
      }, {
        value: _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN_OR_EQUAL,
        text: (0, _utils.operatorToText)(_mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN_OR_EQUAL)
      }]
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        width: 200
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
      value: +this.props.value,
      onChange: this.changeValue
    })))));
  }
  render() {
    const {
      index,
      appliesTo,
      operator,
      value,
      deleteCondition
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "appliesToPopover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.ruleEditor.conditionExpression.appliesToButtonLabel",
          defaultMessage: "when"
        }),
        value: (0, _utils.appliesToText)(appliesTo),
        isActive: this.state.isAppliesToOpen,
        onClick: this.openAppliesTo
      }),
      isOpen: this.state.isAppliesToOpen,
      closePopover: this.closeAppliesTo,
      panelPaddingSize: "s",
      ownFocus: true,
      anchorPosition: "downLeft"
    }, this.renderAppliesToPopover())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "operatorValuePopover",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiExpression, {
        description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.ruleEditor.conditionExpression.operatorValueButtonLabel",
          defaultMessage: "is {operator}",
          values: {
            operator: (0, _utils.operatorToText)(operator)
          }
        }),
        value: `${value}`,
        isActive: this.state.isOperatorValueOpen,
        onClick: this.openOperatorValue
      }),
      isOpen: this.state.isOperatorValueOpen,
      closePopover: this.closeOperatorValue,
      panelPaddingSize: "s",
      ownFocus: true,
      withTitle: true,
      anchorPosition: "downLeft"
    }, this.renderOperatorValuePopover())), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      size: "s",
      color: "danger",
      onClick: () => deleteCondition(index),
      iconType: "trash",
      "aria-label": _i18n.i18n.translate('xpack.ml.ruleEditor.conditionExpression.deleteConditionButtonAriaLabel', {
        defaultMessage: 'Delete condition'
      })
    })));
  }
}
exports.ConditionExpression = ConditionExpression;
(0, _defineProperty2.default)(ConditionExpression, "propTypes", {
  index: _propTypes.default.number.isRequired,
  appliesTo: _propTypes.default.oneOf([_mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.ACTUAL, _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.TYPICAL, _mlAnomalyUtils.ML_DETECTOR_RULE_APPLIES_TO.DIFF_FROM_TYPICAL]),
  operator: _propTypes.default.oneOf([_mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN, _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.LESS_THAN_OR_EQUAL, _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN, _mlAnomalyUtils.ML_DETECTOR_RULE_OPERATOR.GREATER_THAN_OR_EQUAL]),
  value: _propTypes.default.number.isRequired,
  updateCondition: _propTypes.default.func.isRequired,
  deleteCondition: _propTypes.default.func.isRequired
});