"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsInfoButton = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactField = require("@kbn/react-field");
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
var _get_field_icon_types = require("../../../../common/util/get_field_icon_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldStatsInfoButton = ({
  field,
  label,
  searchValue = '',
  onButtonClick
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('xpack.ml.newJob.wizard.fieldContextPopover.inspectFieldStatsTooltip', {
      defaultMessage: 'Inspect field statistics'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": `mlInspectFieldStatsButton-${field.id}`,
    disabled: field.id === _mlAnomalyUtils.EVENT_RATE_FIELD_ID,
    size: "xs",
    iconType: "inspect",
    onClick: ev => {
      if (ev.type === 'click') {
        ev.currentTarget.focus();
      }
      ev.preventDefault();
      ev.stopPropagation();
      if (onButtonClick) {
        onButtonClick(field);
      }
    },
    "aria-label": _i18n.i18n.translate('xpack.ml.newJob.wizard.fieldContextPopover.inspectFieldStatsTooltipArialabel', {
      defaultMessage: 'Inspect field statistics'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      paddingRight: '4px'
    }
  }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
    type: (0, _get_field_icon_types.getKbnFieldIconType)(field.type),
    fill: "none"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHighlight, {
    search: searchValue
  }, label)));
};
exports.FieldStatsInfoButton = FieldStatsInfoButton;