"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldStatsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-field-list-plugin/public");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _new_job_utils = require("../../jobs/new_job/utils/new_job_utils");
var _use_field_stats_flytout_context = require("./use_field_stats_flytout_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DSL_QUERY = (0, _new_job_utils.getDefaultDatafeedQuery)();
const DEFAULT_COLOR = (0, _eui.euiPaletteColorBlind)()[0];
const FieldStatsContent = ({
  dataView: selectedDataView,
  fieldStatsServices,
  timeRangeMs,
  dslQuery
}) => {
  const {
    fieldName
  } = (0, _use_field_stats_flytout_context.useFieldStatsFlyoutContext)();

  // Format timestamp to ISO formatted date strings
  const timeRange = (0, _react.useMemo)(() => {
    // Use the provided timeRange if available
    if (timeRangeMs) {
      return {
        from: (0, _moment.default)(timeRangeMs.from).toISOString(),
        to: (0, _moment.default)(timeRangeMs.to).toISOString()
      };
    }

    // If time range is available via jobCreator, use that
    // else mimic Discover and set timeRange to be now for data view without time field
    const now = (0, _moment.default)();
    return {
      from: now.toISOString(),
      to: now.toISOString()
    };
  }, [timeRangeMs]);
  const fieldForStats = (0, _react.useMemo)(() => (0, _mlIsDefined.isDefined)(fieldName) ? selectedDataView.getFieldByName(fieldName) : undefined, [fieldName, selectedDataView]);
  const showFieldStats = timeRange && (0, _mlIsDefined.isDefined)(selectedDataView) && fieldForStats;
  return showFieldStats ? /*#__PURE__*/_react.default.createElement(_public.FieldStats, {
    key: fieldForStats.name,
    services: fieldStatsServices,
    dslQuery: dslQuery !== null && dslQuery !== void 0 ? dslQuery : DEFAULT_DSL_QUERY,
    fromDate: timeRange.from,
    toDate: timeRange.to,
    dataViewOrDataViewId: selectedDataView,
    field: fieldForStats,
    "data-test-subj": `mlFieldStatsFlyoutContent ${fieldForStats.name}`,
    color: DEFAULT_COLOR
  }) : null;
};
exports.FieldStatsContent = FieldStatsContent;