"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TRAINING_PERCENT_MIN = exports.TRAINING_PERCENT_MAX = exports.TOP_CLASSES = exports.OUTLIER_SCORE = exports.OUTLIER_ANALYSIS_METHOD = exports.NUM_TOP_FEATURE_IMPORTANCE_VALUES_MIN = exports.JOB_MAP_NODE_TYPES = exports.INDEX_CREATED_BY = exports.FEATURE_INFLUENCE = exports.FEATURE_IMPORTANCE = exports.DEFAULT_RESULTS_FIELD = exports.DATA_FRAME_TASK_STATE = exports.ANALYSIS_CONFIG_TYPE = exports.ANALYSIS_ADVANCED_FIELDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Custom enum for DFA config types
 */
const ANALYSIS_CONFIG_TYPE = {
  OUTLIER_DETECTION: 'outlier_detection',
  REGRESSION: 'regression',
  CLASSIFICATION: 'classification'
};

/**
 * Custom enum for DFA task states
 */
exports.ANALYSIS_CONFIG_TYPE = ANALYSIS_CONFIG_TYPE;
const DATA_FRAME_TASK_STATE = {
  ANALYZING: 'analyzing',
  FAILED: 'failed',
  REINDEXING: 'reindexing',
  STARTED: 'started',
  STARTING: 'starting',
  STOPPED: 'stopped'
};

/**
 * Default results field
 */
exports.DATA_FRAME_TASK_STATE = DATA_FRAME_TASK_STATE;
const DEFAULT_RESULTS_FIELD = 'ml';

/**
 * Custom enum for job map node types for the DFA map view
 */
exports.DEFAULT_RESULTS_FIELD = DEFAULT_RESULTS_FIELD;
const JOB_MAP_NODE_TYPES = {
  ANALYTICS: 'analytics',
  TRANSFORM: 'transform',
  INDEX: 'index',
  TRAINED_MODEL: 'trainedModel'
};

/**
 * Union type of JOB_MAP_NODE_TYPES
 */
exports.JOB_MAP_NODE_TYPES = JOB_MAP_NODE_TYPES;
/**
 * Custom enum for the metadata to be stored about which tool was used to create an index
 */
const INDEX_CREATED_BY = {
  FILE_DATA_VISUALIZER: 'file-data-visualizer',
  DATA_FRAME_ANALYTICS: 'data-frame-analytics'
};

/**
 * Feature importance constant
 */
exports.INDEX_CREATED_BY = INDEX_CREATED_BY;
const FEATURE_IMPORTANCE = 'feature_importance';

/**
 * Feature influence constant
 */
exports.FEATURE_IMPORTANCE = FEATURE_IMPORTANCE;
const FEATURE_INFLUENCE = 'feature_influence';

/**
 * Top classes constant
 */
exports.FEATURE_INFLUENCE = FEATURE_INFLUENCE;
const TOP_CLASSES = 'top_classes';

/**
 * Outlier score constant
 */
exports.TOP_CLASSES = TOP_CLASSES;
const OUTLIER_SCORE = 'outlier_score';

/**
 * Enum for a DFA configuration's advanced fields
 */
exports.OUTLIER_SCORE = OUTLIER_SCORE;
let ANALYSIS_ADVANCED_FIELDS;
/**
 * Enum for a DFA configuration's outlier analysis method
 */
exports.ANALYSIS_ADVANCED_FIELDS = ANALYSIS_ADVANCED_FIELDS;
(function (ANALYSIS_ADVANCED_FIELDS) {
  ANALYSIS_ADVANCED_FIELDS["ALPHA"] = "alpha";
  ANALYSIS_ADVANCED_FIELDS["ETA"] = "eta";
  ANALYSIS_ADVANCED_FIELDS["ETA_GROWTH_RATE_PER_TREE"] = "eta_growth_rate_per_tree";
  ANALYSIS_ADVANCED_FIELDS["DOWNSAMPLE_FACTOR"] = "downsample_factor";
  ANALYSIS_ADVANCED_FIELDS["FEATURE_BAG_FRACTION"] = "feature_bag_fraction";
  ANALYSIS_ADVANCED_FIELDS["FEATURE_INFLUENCE_THRESHOLD"] = "feature_influence_threshold";
  ANALYSIS_ADVANCED_FIELDS["GAMMA"] = "gamma";
  ANALYSIS_ADVANCED_FIELDS["LAMBDA"] = "lambda";
  ANALYSIS_ADVANCED_FIELDS["MAX_TREES"] = "max_trees";
  ANALYSIS_ADVANCED_FIELDS["MAX_OPTIMIZATION_ROUNDS_PER_HYPERPARAMETER"] = "max_optimization_rounds_per_hyperparameter";
  ANALYSIS_ADVANCED_FIELDS["METHOD"] = "method";
  ANALYSIS_ADVANCED_FIELDS["N_NEIGHBORS"] = "n_neighbors";
  ANALYSIS_ADVANCED_FIELDS["NUM_TOP_CLASSES"] = "num_top_classes";
  ANALYSIS_ADVANCED_FIELDS["NUM_TOP_FEATURE_IMPORTANCE_VALUES"] = "num_top_feature_importance_values";
  ANALYSIS_ADVANCED_FIELDS["OUTLIER_FRACTION"] = "outlier_fraction";
  ANALYSIS_ADVANCED_FIELDS["RANDOMIZE_SEED"] = "randomize_seed";
  ANALYSIS_ADVANCED_FIELDS["SOFT_TREE_DEPTH_LIMIT"] = "soft_tree_depth_limit";
  ANALYSIS_ADVANCED_FIELDS["SOFT_TREE_DEPTH_TOLERANCE"] = "soft_tree_depth_tolerance";
})(ANALYSIS_ADVANCED_FIELDS || (exports.ANALYSIS_ADVANCED_FIELDS = ANALYSIS_ADVANCED_FIELDS = {}));
let OUTLIER_ANALYSIS_METHOD;
/**
 * Minimum value for feature importance
 */
exports.OUTLIER_ANALYSIS_METHOD = OUTLIER_ANALYSIS_METHOD;
(function (OUTLIER_ANALYSIS_METHOD) {
  OUTLIER_ANALYSIS_METHOD["LOF"] = "lof";
  OUTLIER_ANALYSIS_METHOD["LDOF"] = "ldof";
  OUTLIER_ANALYSIS_METHOD["DISTANCE_KTH_NN"] = "distance_kth_nn";
  OUTLIER_ANALYSIS_METHOD["DISTANCE_KNN"] = "distance_knn";
})(OUTLIER_ANALYSIS_METHOD || (exports.OUTLIER_ANALYSIS_METHOD = OUTLIER_ANALYSIS_METHOD = {}));
const NUM_TOP_FEATURE_IMPORTANCE_VALUES_MIN = 0;

/**
 * Minimum training percent
 */
exports.NUM_TOP_FEATURE_IMPORTANCE_VALUES_MIN = NUM_TOP_FEATURE_IMPORTANCE_VALUES_MIN;
const TRAINING_PERCENT_MIN = 1;

/**
 * Maximum training percent
 */
exports.TRAINING_PERCENT_MIN = TRAINING_PERCENT_MIN;
const TRAINING_PERCENT_MAX = 100;
exports.TRAINING_PERCENT_MAX = TRAINING_PERCENT_MAX;