"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapPage = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _map_app = require("./map_app");
var _saved_map = require("./saved_map");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// react-router-dom.route "render" method may be called multiple times for the same route.
// Therefore state can not exist in the "render" closure
// MapAppContainer exists to wrap MapApp in a component so that a single instance of SavedMap
// exists per route regardless of how many times render method is called.
class MapPage extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "updateSaveCounter", () => {
      if (this._isMounted) {
        this.setState(prevState => {
          return {
            saveCounter: prevState.saveCounter + 1
          };
        });
      }
    });
    this.state = {
      savedMap: new _saved_map.SavedMap({
        defaultLayers: (0, _saved_map.getInitialLayersFromUrlParam)(),
        mapEmbeddableInput: props.mapEmbeddableInput,
        embeddableId: props.embeddableId,
        originatingApp: props.originatingApp,
        originatingPath: props.originatingPath,
        stateTransfer: props.stateTransfer,
        onSaveCallback: this.updateSaveCounter,
        defaultLayerWizard: (0, _saved_map.getOpenLayerWizardFromUrlParam)() || ''
      }),
      saveCounter: 0
    };
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
      store: this.state.savedMap.getStore()
    }, /*#__PURE__*/_react.default.createElement(_map_app.MapApp, {
      history: this.props.history,
      savedMap: this.state.savedMap,
      onAppLeave: this.props.onAppLeave,
      setHeaderActionMenu: this.props.setHeaderActionMenu,
      saveCounter: this.state.saveCounter
    }));
  }
}
exports.MapPage = MapPage;