"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataRequest = getDataRequest;
exports.setDataRequest = setDataRequest;
exports.startDataRequest = startDataRequest;
exports.stopDataRequest = stopDataRequest;
exports.updateSourceDataRequest = updateSourceDataRequest;
var _constants = require("../../../common/constants");
var _layer_utils = require("./layer_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function startDataRequest(state, layerId, dataRequestId, requestToken, requestMeta) {
  const layerDescriptor = (0, _layer_utils.findLayerById)(state, layerId);
  if (!layerDescriptor) {
    return state;
  }
  const prevDataRequest = getDataRequest(state, layerId, dataRequestId);
  const dataRequest = prevDataRequest ? {
    ...prevDataRequest
  } : {
    dataId: dataRequestId
  };
  dataRequest.dataRequestMetaAtStart = requestMeta;
  dataRequest.dataRequestToken = requestToken;
  return setDataRequest(state, layerId, dataRequest);
}
function updateSourceDataRequest(state, layerId, newData) {
  const dataRequest = getDataRequest(state, layerId, _constants.SOURCE_DATA_REQUEST_ID);
  return dataRequest ? setDataRequest(state, layerId, {
    ...dataRequest,
    data: newData
  }) : state;
}
function stopDataRequest(state, layerId, dataRequestId, requestToken, responseMeta, data) {
  const dataRequest = getDataRequest(state, layerId, dataRequestId, requestToken);
  return dataRequest ? setDataRequest(state, layerId, {
    ...dataRequest,
    data,
    dataRequestMeta: {
      ...(dataRequest.dataRequestMetaAtStart ? dataRequest.dataRequestMetaAtStart : {}),
      ...(responseMeta ? responseMeta : {}),
      requestStopTime: Date.now()
    },
    dataRequestMetaAtStart: undefined,
    dataRequestToken: undefined // active data request
  }) : state;
}
function setDataRequest(state, layerId, dataRequest) {
  const layerDescriptor = (0, _layer_utils.findLayerById)(state, layerId);
  if (!layerDescriptor) {
    return state;
  }
  const updatedLayerDescriptor = {
    ...layerDescriptor,
    __dataRequests: layerDescriptor.__dataRequests ? [...layerDescriptor.__dataRequests] : []
  };
  const dataRequestIndex = updatedLayerDescriptor.__dataRequests.findIndex(({
    dataId
  }) => dataRequest.dataId === dataId);
  if (dataRequestIndex === -1) {
    updatedLayerDescriptor.__dataRequests.push(dataRequest);
  } else {
    updatedLayerDescriptor.__dataRequests[dataRequestIndex] = dataRequest;
  }
  return {
    ...state,
    layerList: (0, _layer_utils.setLayer)(state.layerList, updatedLayerDescriptor)
  };
}
function getDataRequest(state, layerId, dataRequestId, requestToken) {
  const layerDescriptor = (0, _layer_utils.findLayerById)(state, layerId);
  if (!layerDescriptor || !layerDescriptor.__dataRequests) {
    return;
  }
  return layerDescriptor.__dataRequests.find(dataRequest => {
    return requestToken ? dataRequest.dataRequestToken === requestToken && dataRequest.dataId === dataRequestId : dataRequest.dataId === dataRequestId;
  });
}