"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MapAdapter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _events = require("events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class MapAdapter extends _events.EventEmitter {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "stats", void 0);
    (0, _defineProperty2.default)(this, "style", void 0);
  }
  setMapState({
    stats,
    style
  }) {
    this.stats = stats;
    this.style = style;
    this._onChange();
  }
  getMapState() {
    return {
      stats: this.stats,
      style: this.style
    };
  }
  _onChange() {
    this.emit('change');
  }
}
exports.MapAdapter = MapAdapter;