"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerTOC = void 0;
var _reactRedux = require("react-redux");
var _layer_toc = require("./layer_toc");
var _actions = require("../../../../actions");
var _map_selectors = require("../../../../selectors/map_selectors");
var _ui_selectors = require("../../../../selectors/ui_selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    isReadOnly: (0, _ui_selectors.getIsReadOnly)(state),
    layerList: (0, _map_selectors.getLayerList)(state),
    openTOCDetails: (0, _ui_selectors.getOpenTOCDetails)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    createLayerGroup: (draggedLayerId, combineWithLayerId) => dispatch((0, _actions.createLayerGroup)(draggedLayerId, combineWithLayerId)),
    moveLayerToBottom: moveLayerId => dispatch((0, _actions.moveLayerToBottom)(moveLayerId)),
    moveLayerToLeftOfTarget: (moveLayerId, targetLayerId) => dispatch((0, _actions.moveLayerToLeftOfTarget)(moveLayerId, targetLayerId)),
    setLayerParent: (layerId, parent) => dispatch((0, _actions.setLayerParent)(layerId, parent))
  };
}
const connected = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_layer_toc.LayerTOC);
exports.LayerTOC = connected;