"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeatureGeometryFilterForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _rison = _interopRequireDefault(require("@kbn/rison"));
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/unified-search-plugin/public");
var _elasticsearch_util = require("../../../../../common/elasticsearch_util");
var _geometry_filter_form = require("../../../../components/draw_forms/geometry_filter_form/geometry_filter_form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// over estimated and imprecise value to ensure filter has additional room for any meta keys added when filter is mapped.
const META_OVERHEAD = 100;
class FeatureGeometryFilterForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isLoading: false,
      errorMsg: undefined
    });
    (0, _defineProperty2.default)(this, "_loadPreIndexedShape", async () => {
      if (!this.props.loadPreIndexedShape) {
        return null;
      }
      this.setState({
        isLoading: true
      });
      let preIndexedShape;
      try {
        preIndexedShape = await this.props.loadPreIndexedShape();
      } catch (err) {
        // ignore error, just fall back to using geometry if preIndexedShape can not be fetched
      }
      if (this._isMounted) {
        this.setState({
          isLoading: false
        });
      }
      return preIndexedShape;
    });
    (0, _defineProperty2.default)(this, "_createFilter", async ({
      geometryLabel,
      relation
    }) => {
      this.setState({
        errorMsg: undefined
      });
      const preIndexedShape = await this._loadPreIndexedShape();
      if (!this._isMounted) {
        // do not create filter if component is unmounted
        return;
      }
      const filter = (0, _elasticsearch_util.buildGeoShapeFilter)({
        preIndexedShape,
        geometry: this.props.geometry,
        geometryLabel,
        geoFieldNames: this.props.geoFieldNames,
        relation
      });

      // Ensure filter will not overflow URL. Filters that contain geometry can be extremely large.
      // No elasticsearch support for pre-indexed shapes and geo_point spatial queries.
      if (window.location.href.length + _rison.default.encode(filter).length + META_OVERHEAD > _public.URL_MAX_LENGTH) {
        this.setState({
          errorMsg: _i18n.i18n.translate('xpack.maps.tooltip.geometryFilterForm.filterTooLargeMessage', {
            defaultMessage: 'Cannot create filter. Filters are added to the URL, and this shape has too many vertices to fit in the URL.'
          })
        });
        return;
      }
      this.props.addFilters([filter], _public2.ACTION_GLOBAL_APPLY_FILTER);
      this.props.onClose();
    });
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_geometry_filter_form.GeometryFilterForm, {
      buttonLabel: _i18n.i18n.translate('xpack.maps.tooltip.geometryFilterForm.createFilterButtonLabel', {
        defaultMessage: 'Create filter'
      }),
      getFilterActions: this.props.getFilterActions,
      getActionContext: this.props.getActionContext,
      intitialGeometryLabel: _i18n.i18n.translate('xpack.maps.tooltip.geometryFilterForm.initialGeometryLabel', {
        defaultMessage: 'feature'
      }),
      onSubmit: this._createFilter,
      isLoading: this.state.isLoading,
      errorMsg: this.state.errorMsg
    });
  }
}
exports.FeatureGeometryFilterForm = FeatureGeometryFilterForm;