"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileStatusTracker = void 0;
var _reactRedux = require("react-redux");
var _actions = require("../../../actions");
var _map_selectors = require("../../../selectors/map_selectors");
var _tile_status_tracker = require("./tile_status_tracker");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  return {
    layerList: (0, _map_selectors.getLayerList)(state)
  };
}
function mapDispatchToProps(dispatch) {
  return {
    setAreTilesLoaded(layerId, areTilesLoaded) {
      dispatch((0, _actions.setAreTilesLoaded)(layerId, areTilesLoaded));
    },
    updateMetaFromTiles(layerId, features) {
      dispatch((0, _actions.updateMetaFromTiles)(layerId, features));
    },
    clearTileLoadError(layerId) {
      dispatch((0, _actions.setLayerDataLoadErrorStatus)(layerId, null));
    },
    setTileLoadError(layerId, errorMessage) {
      dispatch((0, _actions.setLayerDataLoadErrorStatus)(layerId, errorMessage));
    }
  };
}
const connected = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_tile_status_tracker.TileStatusTracker);
exports.TileStatusTracker = connected;