"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutFooter = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _panel_strings = require("../../panel_strings");
var _remove_layer_confirm_modal = require("../../../components/remove_layer_confirm_modal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FlyoutFooter extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      showRemoveModal: false
    });
    (0, _defineProperty2.default)(this, "_showRemoveModal", () => {
      this.setState({
        showRemoveModal: true
      });
    });
  }
  render() {
    const removeModal = this.props.selectedLayer && this.state.showRemoveModal ? /*#__PURE__*/_react.default.createElement(_remove_layer_confirm_modal.RemoveLayerConfirmModal, {
      layer: this.props.selectedLayer,
      onCancel: () => {
        this.setState({
          showRemoveModal: false
        });
      },
      onConfirm: () => {
        this.setState({
          showRemoveModal: false
        });
        this.props.removeLayer();
      }
    }) : null;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, removeModal, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.props.cancelLayerPanel,
      flush: "left",
      "data-test-subj": "layerPanelCancelButton"
    }, this.props.hasStateChanged ? _panel_strings.panelStrings.discardChanges : _panel_strings.panelStrings.close)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: "danger",
      onClick: this._showRemoveModal,
      flush: "right",
      "data-test-subj": "mapRemoveLayerButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.footer.removeLayerButtonLabel",
      defaultMessage: "Remove layer"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      disabled: !this.props.hasStateChanged,
      iconType: "check",
      onClick: this.props.saveLayerEdits,
      fill: true
    }, _panel_strings.panelStrings.keepChanges))));
  }
}
exports.FlyoutFooter = FlyoutFooter;