"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../common/constants");
var _kibana_services = require("../../../kibana_services");
var _global_filter_checkbox = require("../../../components/global_filter_checkbox");
var _global_time_checkbox = require("../../../components/global_time_checkbox");
var _force_refresh_checkbox = require("../../../components/force_refresh_checkbox");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FilterEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false,
      indexPatterns: [],
      isSourceTimeAware: false
    });
    (0, _defineProperty2.default)(this, "_toggle", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_close", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "_onQueryChange", ({
      query
    }) => {
      if (!query) {
        return;
      }
      this.props.setLayerQuery(this.props.layer.getId(), query);
      this._close();
    });
    (0, _defineProperty2.default)(this, "_onApplyGlobalQueryChange", applyGlobalQuery => {
      this.props.updateSourceProp(this.props.layer.getId(), 'applyGlobalQuery', applyGlobalQuery);
    });
    (0, _defineProperty2.default)(this, "_onApplyGlobalTimeChange", applyGlobalTime => {
      this.props.updateSourceProp(this.props.layer.getId(), 'applyGlobalTime', applyGlobalTime);
    });
    (0, _defineProperty2.default)(this, "_onRespondToForceRefreshChange", applyForceRefresh => {
      this.props.updateSourceProp(this.props.layer.getId(), 'applyForceRefresh', applyForceRefresh);
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadIndexPatterns();
    this._loadSourceTimeAware();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadIndexPatterns() {
    // Filter only effects source so only load source indices.
    const indexPatternIds = this.props.layer.getSource().getIndexPatternIds();
    const indexPatterns = [];
    const getIndexPatternPromises = indexPatternIds.map(async indexPatternId => {
      try {
        const indexPattern = await (0, _kibana_services.getIndexPatternService)().get(indexPatternId);
        indexPatterns.push(indexPattern);
      } catch (err) {
        // unable to fetch index pattern
      }
    });
    await Promise.all(getIndexPatternPromises);
    if (!this._isMounted) {
      return;
    }
    this.setState({
      indexPatterns
    });
  }
  async _loadSourceTimeAware() {
    const isSourceTimeAware = await this.props.layer.getSource().isTimeAware();
    if (this._isMounted) {
      this.setState({
        isSourceTimeAware
      });
    }
  }
  _renderQueryPopover() {
    const layerQuery = this.props.layer.getQuery();
    const SearchBar = (0, _kibana_services.getSearchBar)();
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "layerQueryPopover",
      button: this._renderOpenButton(),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._close,
      anchorPosition: "leftCenter",
      ownFocus: true
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "mapFilterEditor",
      "data-test-subj": "mapFilterEditor"
    }, /*#__PURE__*/_react.default.createElement(SearchBar, {
      appName: _constants.APP_ID,
      showFilterBar: false,
      showDatePicker: false,
      showQueryInput: true,
      query: layerQuery ? layerQuery : (0, _kibana_services.getData)().query.queryString.getDefaultQuery(),
      onQuerySubmit: this._onQueryChange,
      indexPatterns: this.state.indexPatterns,
      customSubmitButton: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "mapFilterEditorSubmitButton"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.layerPanel.filterEditor.queryBarSubmitButtonLabel",
        defaultMessage: "Set filter"
      }))
    })));
  }
  _renderQuery() {
    if (this.props.isFeatureEditorOpenForLayer) {
      return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.layerPanel.filterEditor.isLayerFilterNotApplied",
        defaultMessage: "Layer filter is not applied while editing features"
      });
    }
    const query = this.props.layer.getQuery();
    if (!query || !query.query) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.layerPanel.filterEditor.emptyState.description",
        defaultMessage: "Add a filter to narrow the layer data."
      }))));
    }
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      paddingSize: "s"
    }, query.query), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  _renderOpenButton() {
    const query = this.props.layer.getQuery();
    const openButtonLabel = query && query.query ? _i18n.i18n.translate('xpack.maps.layerPanel.filterEditor.editFilterButtonLabel', {
      defaultMessage: 'Edit filter'
    }) : _i18n.i18n.translate('xpack.maps.layerPanel.filterEditor.addFilterButtonLabel', {
      defaultMessage: 'Set filter'
    });
    const openButtonIcon = query && query.query ? 'pencil' : 'plusInCircleFilled';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: this._toggle,
      "data-test-subj": "mapLayerPanelOpenFilterEditorButton",
      iconType: openButtonIcon,
      disabled: this.props.isFeatureEditorOpenForLayer
    }, openButtonLabel);
  }
  render() {
    const globalTimeCheckbox = this.state.isSourceTimeAware ? /*#__PURE__*/_react.default.createElement(_global_time_checkbox.GlobalTimeCheckbox, {
      label: _i18n.i18n.translate('xpack.maps.filterEditor.applyGlobalTimeCheckboxLabel', {
        defaultMessage: `Apply global time to layer data`
      }),
      applyGlobalTime: this.props.layer.getSource().getApplyGlobalTime(),
      setApplyGlobalTime: this._onApplyGlobalTimeChange,
      isFeatureEditorOpenForLayer: this.props.isFeatureEditorOpenForLayer
    }) : null;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.layerPanel.filterEditor.title",
      defaultMessage: "Filtering"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: 'row',
      wrap: false,
      component: 'span'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1
    }, this._renderQueryPopover()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 6
    }, this._renderQuery())), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      size: "full",
      margin: "s"
    }), /*#__PURE__*/_react.default.createElement(_global_filter_checkbox.GlobalFilterCheckbox, {
      label: _i18n.i18n.translate('xpack.maps.filterEditor.applyGlobalQueryCheckboxLabel', {
        defaultMessage: `Apply global search to layer data`
      }),
      applyGlobalQuery: this.props.layer.getSource().getApplyGlobalQuery(),
      setApplyGlobalQuery: this._onApplyGlobalQueryChange,
      isFeatureEditorOpenForLayer: this.props.isFeatureEditorOpenForLayer
    }), globalTimeCheckbox, /*#__PURE__*/_react.default.createElement(_force_refresh_checkbox.ForceRefreshCheckbox, {
      applyForceRefresh: this.props.layer.getSource().getApplyForceRefresh(),
      setApplyForceRefresh: this._onRespondToForceRefreshChange
    }));
  }
}
exports.FilterEditor = FilterEditor;