"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLayerPanel = exports.ADD_LAYER_STEP_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _flyout_body = require("./flyout_body");
var _layer_wizard_registry = require("../../classes/layers/wizards/layer_wizard_registry");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_LAYER_STEP_ID = 'ADD_LAYER_STEP_ID';
exports.ADD_LAYER_STEP_ID = ADD_LAYER_STEP_ID;
const ADD_LAYER_STEP_LABEL = _i18n.i18n.translate('xpack.maps.addLayerPanel.addLayer', {
  defaultMessage: 'Add layer'
});
const ADD_LAYER_STEP_NEXT_BUTTON_LABEL = _i18n.i18n.translate('xpack.maps.addLayerPanel.addLayerNextButtonLabel', {
  defaultMessage: 'Add and continue'
});
const ADD_LAYER_STEP_SECONDARY_ACTION_BUTTON_LABEL = _i18n.i18n.translate('xpack.maps.addLayerPanel.addLayerSecondaryActionButtonLabel', {
  defaultMessage: 'Add and close'
});
const INITIAL_STATE = {
  currentStepIndex: 0,
  currentStep: null,
  layerSteps: null,
  layerWizard: null,
  isNextStepBtnEnabled: false,
  isStepLoading: false
};
class AddLayerPanel extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      ...INITIAL_STATE
    });
    (0, _defineProperty2.default)(this, "_previewLayers", layerDescriptors => {
      this.props.addPreviewLayers(layerDescriptors);
    });
    (0, _defineProperty2.default)(this, "_clearLayerWizard", () => {
      this.setState(INITIAL_STATE);
      this.props.addPreviewLayers([]);
    });
    (0, _defineProperty2.default)(this, "_onWizardSelect", layerWizard => {
      const layerSteps = [...(layerWizard.prerequisiteSteps ? layerWizard.prerequisiteSteps : []), {
        id: ADD_LAYER_STEP_ID,
        label: ADD_LAYER_STEP_LABEL,
        nextButtonLabel: ADD_LAYER_STEP_NEXT_BUTTON_LABEL,
        renderSecondaryActionButton: ({
          isDisabled,
          isLoading,
          addLayersAndClose
        }) => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            disabled: isDisabled || isLoading,
            isLoading: isLoading,
            onClick: addLayersAndClose,
            iconSide: "right"
          }, ADD_LAYER_STEP_SECONDARY_ACTION_BUTTON_LABEL);
        }
      }];
      this.setState({
        ...INITIAL_STATE,
        layerWizard,
        layerSteps,
        currentStep: layerSteps[0]
      });
    });
    (0, _defineProperty2.default)(this, "_onNext", () => {
      if (!this.state.layerSteps) {
        return;
      }
      if (this.state.layerSteps.length - 1 === this.state.currentStepIndex) {
        var _this$state$layerWiza;
        // last step
        this.props.addLayersAndContinue();
        if ((_this$state$layerWiza = this.state.layerWizard) !== null && _this$state$layerWiza !== void 0 && _this$state$layerWiza.showFeatureEditTools) {
          this.props.enableEditMode();
        }
      } else {
        this.setState(prevState => {
          const nextIndex = prevState.currentStepIndex + 1;
          return {
            currentStepIndex: nextIndex,
            currentStep: prevState.layerSteps[nextIndex],
            isNextStepBtnEnabled: false,
            isStepLoading: false
          };
        });
      }
    });
    (0, _defineProperty2.default)(this, "_enableNextBtn", () => {
      this.setState({
        isNextStepBtnEnabled: true
      });
    });
    (0, _defineProperty2.default)(this, "_disableNextBtn", () => {
      this.setState({
        isNextStepBtnEnabled: false
      });
    });
    (0, _defineProperty2.default)(this, "_startStepLoading", () => {
      this.setState({
        isStepLoading: true
      });
    });
    (0, _defineProperty2.default)(this, "_stopStepLoading", () => {
      this.setState({
        isStepLoading: false
      });
    });
  }
  componentDidMount() {
    if (this.props.autoOpenLayerWizardId) {
      this._openWizard();
    }
  }
  _openWizard() {
    const selectedWizard = (0, _layer_wizard_registry.getWizardById)(this.props.autoOpenLayerWizardId);
    if (selectedWizard) {
      this._onWizardSelect(selectedWizard);
    }
    this.props.clearAutoOpenLayerWizardId();
  }
  _renderNextButton() {
    if (!this.state.currentStep) {
      return null;
    }
    let isDisabled = !this.state.isNextStepBtnEnabled;
    let isLoading = this.state.isStepLoading;
    if (this.state.currentStep.id === ADD_LAYER_STEP_ID) {
      isDisabled = !this.props.hasPreviewLayers;
      isLoading = this.props.isLoadingPreviewLayers;
    } else {
      isDisabled = !this.state.isNextStepBtnEnabled;
      isLoading = this.state.isStepLoading;
    }
    const nextButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "importFileButton",
      disabled: isDisabled || isLoading,
      isLoading: isLoading,
      iconSide: "right",
      iconType: 'arrowRight',
      onClick: this._onNext,
      fill: true
    }, this.state.currentStep.nextButtonLabel ? this.state.currentStep.nextButtonLabel : this.state.currentStep.label));
    return this.state.currentStep.renderSecondaryActionButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, this.state.currentStep.renderSecondaryActionButton({
      isDisabled,
      isLoading,
      addLayersAndClose: this.props.addLayersAndClose
    })), nextButton)) : nextButton;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
      hasBorder: true,
      className: "mapLayerPanel__header"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", null, this.state.currentStep ? this.state.currentStep.label : ADD_LAYER_STEP_LABEL))), /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
      layerWizard: this.state.layerWizard,
      onClear: this._clearLayerWizard,
      onWizardSelect: this._onWizardSelect,
      previewLayers: this._previewLayers,
      showBackButton: !this.state.isStepLoading,
      currentStepId: this.state.currentStep ? this.state.currentStep.id : null,
      isOnFinalStep: this.state.currentStep ? this.state.currentStep.id === ADD_LAYER_STEP_ID : false,
      enableNextBtn: this._enableNextBtn,
      disableNextBtn: this._disableNextBtn,
      startStepLoading: this._startStepLoading,
      stopStepLoading: this._stopStepLoading,
      advanceToNextStep: this._onNext
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
      className: "mapLayerPanel__footer"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      responsive: false,
      gutterSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: this.props.closeFlyout,
      flush: "left",
      "data-test-subj": "layerAddCancelButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.addLayerPanel.footer.cancelButtonLabel",
      defaultMessage: "Cancel"
    }))), this._renderNextButton())));
  }
}
exports.AddLayerPanel = AddLayerPanel;