"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ESTermSource = void 0;
exports.extractPropertiesMap = extractPropertiesMap;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _get_agg_key = require("../../../../../common/get_agg_key");
var _es_doc_field = require("../../../fields/es_doc_field");
var _es_agg_source = require("../../es_agg_source");
var _elasticsearch_util = require("../../../../../common/elasticsearch_util");
var _valid_string_config = require("../../../util/valid_string_config");
var _execution_context_utils = require("../../execution_context_utils");
var _is_term_source_complete = require("./is_term_source_complete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TERMS_AGG_NAME = 'join';
const TERMS_BUCKET_KEYS_TO_IGNORE = ['key', 'doc_count'];
function extractPropertiesMap(rawEsData, countPropertyName) {
  var _rawEsData$aggregatio, _rawEsData$aggregatio2, _rawEsData$aggregatio3;
  const propertiesMap = new Map();
  const buckets = (_rawEsData$aggregatio = rawEsData === null || rawEsData === void 0 ? void 0 : (_rawEsData$aggregatio2 = rawEsData.aggregations) === null || _rawEsData$aggregatio2 === void 0 ? void 0 : (_rawEsData$aggregatio3 = _rawEsData$aggregatio2[TERMS_AGG_NAME]) === null || _rawEsData$aggregatio3 === void 0 ? void 0 : _rawEsData$aggregatio3.buckets) !== null && _rawEsData$aggregatio !== void 0 ? _rawEsData$aggregatio : [];
  buckets.forEach(termBucket => {
    const properties = (0, _elasticsearch_util.extractPropertiesFromBucket)(termBucket, TERMS_BUCKET_KEYS_TO_IGNORE);
    if (countPropertyName) {
      properties[countPropertyName] = termBucket.doc_count;
    }
    propertiesMap.set(termBucket.key.toString(), properties);
  });
  return propertiesMap;
}
class ESTermSource extends _es_agg_source.AbstractESAggSource {
  static createDescriptor(descriptor) {
    const normalizedDescriptor = _es_agg_source.AbstractESAggSource.createDescriptor(descriptor);
    if (!(0, _valid_string_config.isValidStringConfig)(descriptor.term)) {
      throw new Error('Cannot create an ESTermSource without a term');
    }
    return {
      ...normalizedDescriptor,
      term: descriptor.term,
      type: _constants.SOURCE_TYPES.ES_TERM_SOURCE
    };
  }
  constructor(descriptor) {
    const sourceDescriptor = ESTermSource.createDescriptor(descriptor);
    super(sourceDescriptor);
    (0, _defineProperty2.default)(this, "_termField", void 0);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = sourceDescriptor;
    this._termField = new _es_doc_field.ESDocField({
      fieldName: this._descriptor.term,
      source: this,
      origin: this.getOriginForField()
    });
  }
  hasCompleteConfig() {
    return (0, _is_term_source_complete.isTermSourceComplete)(this._descriptor);
  }
  getTermField() {
    return this._termField;
  }
  getOriginForField() {
    return _constants.FIELD_ORIGIN.JOIN;
  }
  getWhereQuery() {
    return this._descriptor.whereQuery;
  }
  getAggKey(aggType, fieldName) {
    return (0, _get_agg_key.getJoinAggKey)({
      aggType,
      aggFieldName: fieldName,
      rightSourceId: this._descriptor.id
    });
  }
  async getAggLabel(aggType, fieldLabel) {
    let indexPatternLabel;
    try {
      const indexPattern = await this.getIndexPattern();
      indexPatternLabel = indexPattern.getName();
    } catch (error) {
      indexPatternLabel = this._descriptor.indexPatternId;
    }
    return aggType === _constants.AGG_TYPE.COUNT ? _i18n.i18n.translate('xpack.maps.source.esJoin.countLabel', {
      defaultMessage: `count of {indexPatternLabel}`,
      values: {
        indexPatternLabel
      }
    }) : super.getAggLabel(aggType, fieldLabel);
  }
  async getPropertiesMap(requestMeta, leftSourceName, leftFieldName, registerCancelCallback, inspectorAdapters) {
    if (!this.hasCompleteConfig()) {
      return new Map();
    }
    const indexPattern = await this.getIndexPattern();
    const searchSource = await this.makeSearchSource(requestMeta, 0);
    searchSource.setField('trackTotalHits', false);
    const termsField = (0, _elasticsearch_util.getField)(indexPattern, this._termField.getName());
    const termsAgg = {
      size: this._descriptor.size !== undefined ? this._descriptor.size : _constants.DEFAULT_MAX_BUCKETS_LIMIT
    };
    searchSource.setField('aggs', {
      [TERMS_AGG_NAME]: {
        terms: (0, _elasticsearch_util.addFieldToDSL)(termsAgg, termsField),
        aggs: {
          ...this.getValueAggsDsl(indexPattern)
        }
      }
    });
    const rawEsData = await this._runEsQuery({
      requestId: this.getId(),
      requestName: _i18n.i18n.translate('xpack.maps.termSource.requestName', {
        defaultMessage: '{leftSourceName} term join request',
        values: {
          leftSourceName
        }
      }),
      searchSource,
      registerCancelCallback,
      requestDescription: _i18n.i18n.translate('xpack.maps.termSource.requestDescription', {
        defaultMessage: 'Get metrics from data view: {dataViewName}, term field: {termFieldName}',
        values: {
          dataViewName: indexPattern.getName(),
          termFieldName: this._termField.getName()
        }
      }),
      searchSessionId: requestMeta.searchSessionId,
      executionContext: (0, _execution_context_utils.mergeExecutionContext)({
        description: 'es_term_source:terms'
      }, requestMeta.executionContext),
      requestsAdapter: inspectorAdapters.requests
    });
    const countPropertyName = this.getAggKey(_constants.AGG_TYPE.COUNT);
    return extractPropertiesMap(rawEsData, countPropertyName);
  }
  isFilterByMapBounds() {
    return false;
  }
  async getDisplayName() {
    // no need to localize. this is never rendered.
    return `es_table ${this.getIndexPatternId()}`;
  }
  getFieldNames() {
    return this.getMetricFields().map(esAggMetricField => esAggMetricField.getName());
  }
  getSyncMeta() {
    return {
      indexPatternId: this._descriptor.indexPatternId,
      size: this._descriptor.size,
      term: this._descriptor.term
    };
  }
  getRightFields() {
    return this.getMetricFields();
  }
}
exports.ESTermSource = ESTermSource;
(0, _defineProperty2.default)(ESTermSource, "type", _constants.SOURCE_TYPES.ES_TERM_SOURCE);