"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.spatialJoinWizardConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _wizard_form = require("./wizard_form");
var _spatial_join_layer_icon = require("../icons/spatial_join_layer_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const spatialJoinWizardConfig = {
  id: _constants.WIZARD_ID.SPATIAL_JOIN,
  order: 10,
  categories: [_constants.LAYER_WIZARD_CATEGORY.ELASTICSEARCH],
  description: _i18n.i18n.translate('xpack.maps.spatialJoinWizard.description', {
    defaultMessage: 'Group documents by geospatial relationships'
  }),
  icon: _spatial_join_layer_icon.SpatialJoinLayerIcon,
  renderWizard: renderWizardArguments => {
    return /*#__PURE__*/_react.default.createElement(_wizard_form.WizardForm, renderWizardArguments);
  },
  title: _i18n.i18n.translate('xpack.maps.spatialJoinWizard.title', {
    defaultMessage: 'Spatial join'
  })
};
exports.spatialJoinWizardConfig = spatialJoinWizardConfig;