"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _contants = require("../common/contants");
var _locator = require("../common/locator");
var _management_sections_service = require("./management_sections_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class ManagementPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "managementSections", new _management_sections_service.ManagementSectionsService());
    (0, _defineProperty2.default)(this, "appUpdater", new _rxjs.BehaviorSubject(() => {
      const deepLinks = Object.values(this.managementSections.definedSections).map(section => ({
        id: section.id,
        title: section.title,
        deepLinks: section.getAppsEnabled().map(mgmtApp => ({
          id: mgmtApp.id,
          title: mgmtApp.title,
          path: mgmtApp.basePath,
          keywords: mgmtApp.keywords
        }))
      }));
      return {
        deepLinks
      };
    }));
    (0, _defineProperty2.default)(this, "hasAnyEnabledApps", true);
    (0, _defineProperty2.default)(this, "isSidebarEnabled$", new _rxjs.BehaviorSubject(true));
    this.initializerContext = initializerContext;
  }
  setup(core, {
    home,
    share
  }) {
    const kibanaVersion = this.initializerContext.env.packageInfo.version;
    const locator = share.url.locators.create(new _locator.ManagementAppLocatorDefinition());
    const managementPlugin = this;
    if (home) {
      home.featureCatalogue.register({
        id: 'stack-management',
        title: _i18n.i18n.translate('management.stackManagement.managementLabel', {
          defaultMessage: 'Stack Management'
        }),
        description: _i18n.i18n.translate('management.stackManagement.managementDescription', {
          defaultMessage: 'Your center console for managing the Elastic Stack.'
        }),
        icon: 'managementApp',
        path: '/app/management',
        showOnHomePage: false,
        category: 'admin',
        visible: () => this.hasAnyEnabledApps
      });
    }
    core.application.register({
      id: _contants.MANAGEMENT_APP_ID,
      title: _i18n.i18n.translate('management.stackManagement.title', {
        defaultMessage: 'Stack Management'
      }),
      order: 9040,
      euiIconType: 'logoElastic',
      category: _public.DEFAULT_APP_CATEGORIES.management,
      updater$: this.appUpdater,
      async mount(params) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const [coreStart] = await core.getStartServices();
        return renderApp(params, {
          sections: (0, _management_sections_service.getSectionsServiceStartPrivate)(),
          kibanaVersion,
          setBreadcrumbs: coreStart.chrome.setBreadcrumbs,
          isSidebarEnabled$: managementPlugin.isSidebarEnabled$
        });
      }
    });
    return {
      sections: this.managementSections.setup(),
      locator
    };
  }
  start(core, _plugins) {
    this.managementSections.start({
      capabilities: core.application.capabilities
    });
    this.hasAnyEnabledApps = (0, _management_sections_service.getSectionsServiceStartPrivate)().getSectionsEnabled().some(section => section.getAppsEnabled().length > 0);
    if (!this.hasAnyEnabledApps) {
      this.appUpdater.next(() => {
        return {
          status: _public.AppStatus.inaccessible,
          navLinkStatus: _public.AppNavLinkStatus.hidden
        };
      });
    }
    return {
      setIsSidebarEnabled: isSidebarEnabled => this.isSidebarEnabled$.next(isSidebarEnabled)
    };
  }
}
exports.ManagementPlugin = ManagementPlugin;