"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.App = void 0;
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _app = require("./app");
var _license_management = require("./store/reducers/license_management");
var _permissions = require("./store/actions/permissions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = state => {
  return {
    hasPermission: (0, _license_management.getPermission)(state),
    permissionsLoading: (0, _license_management.isPermissionsLoading)(state),
    permissionsError: (0, _license_management.getPermissionsError)(state)
  };
};
const mapDispatchToProps = {
  loadPermissions: _permissions.loadPermissions
};
const App = (0, _reactRouterDom.withRouter)((0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_app.App));
exports.App = App;