"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GaugeToolbar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/visualization-ui-components/public");
var _shared_components = require("../../../shared_components");
require("./gauge_config_panel.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GaugeToolbar = /*#__PURE__*/(0, _react.memo)(props => {
  var _frame$activeData, _frame$activeData$sta, _frame$activeData$sta2;
  const {
    state,
    setState,
    frame
  } = props;
  const metricDimensionTitle = state.layerId && ((_frame$activeData = frame.activeData) === null || _frame$activeData === void 0 ? void 0 : (_frame$activeData$sta = _frame$activeData[state.layerId]) === null || _frame$activeData$sta === void 0 ? void 0 : (_frame$activeData$sta2 = _frame$activeData$sta.columns.find(col => col.id === state.metricAccessor)) === null || _frame$activeData$sta2 === void 0 ? void 0 : _frame$activeData$sta2.name);
  const [subtitleMode, setSubtitleMode] = (0, _react.useState)(() => state.labelMinor ? 'custom' : 'none');
  const {
    inputValue,
    handleInputChange
  } = (0, _public.useDebouncedValue)({
    onChange: setState,
    value: state
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    handleClose: () => {
      setSubtitleMode(inputValue.labelMinor ? 'custom' : 'none');
    },
    title: _i18n.i18n.translate('xpack.lens.gauge.appearanceLabel', {
      defaultMessage: 'Appearance'
    }),
    type: "visualOptions",
    buttonDataTestSubj: "lnsVisualOptionsButton",
    panelClassName: "lnsGaugeToolbar__popover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.gauge.labelMajor.header', {
      defaultMessage: 'Title'
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_shared_components.VisLabel, {
    header: _i18n.i18n.translate('xpack.lens.label.gauge.labelMajor.header', {
      defaultMessage: 'Title'
    }),
    dataTestSubj: "lnsToolbarGaugeLabelMajor",
    label: inputValue.labelMajor || '',
    mode: inputValue.labelMajorMode,
    placeholder: metricDimensionTitle || '',
    hasAutoOption: true,
    handleChange: value => {
      handleInputChange({
        ...inputValue,
        labelMajor: value.label,
        labelMajorMode: value.mode
      });
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.label.gauge.labelMinor.header', {
      defaultMessage: 'Subtitle'
    })
  }, /*#__PURE__*/_react.default.createElement(_shared_components.VisLabel, {
    header: _i18n.i18n.translate('xpack.lens.label.gauge.labelMinor.header', {
      defaultMessage: 'Subtitle'
    }),
    dataTestSubj: "lnsToolbarGaugeLabelMinor",
    label: inputValue.labelMinor || '',
    mode: subtitleMode,
    handleChange: value => {
      handleInputChange({
        ...inputValue,
        labelMinor: value.label
      });
      setSubtitleMode(value.mode);
    }
  }))))));
});
exports.GaugeToolbar = GaugeToolbar;