"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectVisualizationState = exports.selectVisualization = exports.selectTriggerApplyChanges = exports.selectStagedPreview = exports.selectStagedActiveData = exports.selectSearchSessionId = exports.selectSavedObjectFormat = exports.selectResolvedDateRange = exports.selectQuery = exports.selectPersistedDoc = exports.selectIsFullscreenDatasource = exports.selectFramePublicAPI = exports.selectFrameDatasourceAPI = exports.selectFilters = exports.selectExecutionContextSearch = exports.selectExecutionContext = exports.selectDatasourceStates = exports.selectDatasourceLayers = exports.selectDataViews = exports.selectCurrentVisualization = exports.selectCurrentDatasourceStates = exports.selectChangesApplied = exports.selectAutoApplyEnabled = exports.selectAreDatasourcesLoaded = exports.selectAdHocDataViews = exports.selectActiveDatasourceId = exports.selectActiveData = void 0;
var _toolkit = require("@reduxjs/toolkit");
var _common = require("@kbn/data-views-plugin/common");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectPersistedDoc = state => state.lens.persistedDoc;
exports.selectPersistedDoc = selectPersistedDoc;
const selectQuery = state => state.lens.query;
exports.selectQuery = selectQuery;
const selectSearchSessionId = state => state.lens.searchSessionId;
exports.selectSearchSessionId = selectSearchSessionId;
const selectFilters = state => state.lens.filters;
exports.selectFilters = selectFilters;
const selectResolvedDateRange = state => state.lens.resolvedDateRange;
exports.selectResolvedDateRange = selectResolvedDateRange;
const selectAdHocDataViews = state => Object.fromEntries(Object.values(state.lens.dataViews.indexPatterns).filter(indexPattern => !indexPattern.isPersisted).map(indexPattern => [indexPattern.id, indexPattern.spec]));
exports.selectAdHocDataViews = selectAdHocDataViews;
const selectVisualization = state => state.lens.visualization;
exports.selectVisualization = selectVisualization;
const selectStagedPreview = state => state.lens.stagedPreview;
exports.selectStagedPreview = selectStagedPreview;
const selectStagedActiveData = state => {
  var _state$lens$stagedPre;
  return ((_state$lens$stagedPre = state.lens.stagedPreview) === null || _state$lens$stagedPre === void 0 ? void 0 : _state$lens$stagedPre.activeData) || state.lens.activeData;
};
exports.selectStagedActiveData = selectStagedActiveData;
const selectAutoApplyEnabled = state => !state.lens.autoApplyDisabled;
exports.selectAutoApplyEnabled = selectAutoApplyEnabled;
const selectChangesApplied = state => !state.lens.autoApplyDisabled || Boolean(state.lens.changesApplied);
exports.selectChangesApplied = selectChangesApplied;
const selectDatasourceStates = state => state.lens.datasourceStates;
exports.selectDatasourceStates = selectDatasourceStates;
const selectVisualizationState = state => state.lens.visualization;
exports.selectVisualizationState = selectVisualizationState;
const selectActiveDatasourceId = state => state.lens.activeDatasourceId;
exports.selectActiveDatasourceId = selectActiveDatasourceId;
const selectActiveData = state => state.lens.activeData;
exports.selectActiveData = selectActiveData;
const selectDataViews = state => state.lens.dataViews;
exports.selectDataViews = selectDataViews;
const selectIsFullscreenDatasource = state => Boolean(state.lens.isFullscreenDatasource);
exports.selectIsFullscreenDatasource = selectIsFullscreenDatasource;
let applyChangesCounter;
const selectTriggerApplyChanges = state => {
  const shouldApply = state.lens.applyChangesCounter !== applyChangesCounter;
  applyChangesCounter = state.lens.applyChangesCounter;
  return shouldApply;
};
exports.selectTriggerApplyChanges = selectTriggerApplyChanges;
const selectExecutionContext = (0, _toolkit.createSelector)([selectQuery, selectFilters, selectResolvedDateRange], (query, filters, dateRange) => ({
  dateRange,
  query,
  filters
}));
exports.selectExecutionContext = selectExecutionContext;
const selectExecutionContextSearch = (0, _toolkit.createSelector)(selectExecutionContext, res => ({
  query: res.query,
  timeRange: {
    from: res.dateRange.fromDate,
    to: res.dateRange.toDate
  },
  filters: res.filters,
  disableShardWarnings: true
}));
exports.selectExecutionContextSearch = selectExecutionContextSearch;
const selectInjectedDependencies = (_state, dependencies) => dependencies;

// use this type to cast selectInjectedDependencies to require whatever outside dependencies the selector needs

const selectSavedObjectFormat = (0, _toolkit.createSelector)([selectPersistedDoc, selectVisualization, selectDatasourceStates, selectQuery, selectFilters, selectActiveDatasourceId, selectAdHocDataViews, selectInjectedDependencies], (persistedDoc, visualization, datasourceStates, query, filters, activeDatasourceId, adHocDataViews, {
  datasourceMap,
  visualizationMap,
  extractFilterReferences
}) => {
  const activeVisualization = visualization.state && visualization.activeId ? visualizationMap[visualization.activeId] : null;
  const activeDatasource = datasourceStates && activeDatasourceId && !datasourceStates[activeDatasourceId].isLoading ? datasourceMap[activeDatasourceId] : undefined;
  if (!activeDatasource || !activeVisualization) {
    return;
  }
  const activeDatasources = Object.keys(datasourceStates).reduce((acc, datasourceId) => ({
    ...acc,
    [datasourceId]: datasourceMap[datasourceId]
  }), {});
  const persistibleDatasourceStates = {};
  const references = [];
  const internalReferences = [];
  Object.entries(activeDatasources).forEach(([id, datasource]) => {
    const {
      state: persistableState,
      savedObjectReferences
    } = datasource.getPersistableState(datasourceStates[id].state);
    persistibleDatasourceStates[id] = persistableState;
    savedObjectReferences.forEach(r => {
      if (r.type === 'index-pattern' && adHocDataViews[r.id]) {
        internalReferences.push(r);
      } else {
        references.push(r);
      }
    });
  });
  let persistibleVisualizationState = visualization.state;
  if (activeVisualization.getPersistableState) {
    const {
      state: persistableState,
      savedObjectReferences
    } = activeVisualization.getPersistableState(visualization.state);
    persistibleVisualizationState = persistableState;
    savedObjectReferences.forEach(r => {
      if (r.type === 'index-pattern' && adHocDataViews[r.id]) {
        internalReferences.push(r);
      } else {
        references.push(r);
      }
    });
  }
  const persistableAdHocDataViews = Object.fromEntries(Object.entries(adHocDataViews).map(([id, dataView]) => {
    const {
      references: dataViewReferences,
      state
    } = _common.DataViewPersistableStateService.extract(dataView);
    references.push(...dataViewReferences);
    return [id, state];
  }));
  const adHocFilters = filters.filter(f => !references.some(r => r.type === 'index-pattern' && r.id === f.meta.index)).map(f => ({
    ...f,
    meta: {
      ...f.meta,
      value: undefined
    }
  }));
  const referencedFilters = filters.filter(f => references.some(r => r.type === 'index-pattern' && r.id === f.meta.index));
  const {
    state: persistableFilters,
    references: filterReferences
  } = extractFilterReferences(referencedFilters);
  references.push(...filterReferences);
  return {
    savedObjectId: persistedDoc === null || persistedDoc === void 0 ? void 0 : persistedDoc.savedObjectId,
    title: (persistedDoc === null || persistedDoc === void 0 ? void 0 : persistedDoc.title) || '',
    description: persistedDoc === null || persistedDoc === void 0 ? void 0 : persistedDoc.description,
    visualizationType: visualization.activeId,
    type: 'lens',
    references,
    state: {
      visualization: persistibleVisualizationState,
      query,
      filters: [...persistableFilters, ...adHocFilters],
      datasourceStates: persistibleDatasourceStates,
      internalReferences,
      adHocDataViews: persistableAdHocDataViews
    }
  };
});
exports.selectSavedObjectFormat = selectSavedObjectFormat;
const selectCurrentVisualization = (0, _toolkit.createSelector)([selectVisualization, selectStagedPreview], (visualization, stagedPreview) => stagedPreview ? stagedPreview.visualization : visualization);
exports.selectCurrentVisualization = selectCurrentVisualization;
const selectCurrentDatasourceStates = (0, _toolkit.createSelector)([selectDatasourceStates, selectStagedPreview], (datasourceStates, stagedPreview) => stagedPreview ? stagedPreview.datasourceStates : datasourceStates);
exports.selectCurrentDatasourceStates = selectCurrentDatasourceStates;
const selectAreDatasourcesLoaded = (0, _toolkit.createSelector)(selectDatasourceStates, datasourceStates => Object.values(datasourceStates).every(({
  isLoading
}) => isLoading === false));
exports.selectAreDatasourcesLoaded = selectAreDatasourcesLoaded;
const selectDatasourceLayers = (0, _toolkit.createSelector)([selectDatasourceStates, selectInjectedDependencies, selectDataViews], (datasourceStates, datasourceMap, dataViews) => (0, _utils.getDatasourceLayers)(datasourceStates, datasourceMap, dataViews.indexPatterns));
exports.selectDatasourceLayers = selectDatasourceLayers;
const selectFramePublicAPI = (0, _toolkit.createSelector)([selectCurrentDatasourceStates, selectActiveData, selectInjectedDependencies, selectResolvedDateRange, selectDataViews], (datasourceStates, activeData, datasourceMap, dateRange, dataViews) => {
  return {
    datasourceLayers: (0, _utils.getDatasourceLayers)(datasourceStates, datasourceMap, dataViews.indexPatterns),
    activeData,
    dateRange,
    dataViews
  };
});
exports.selectFramePublicAPI = selectFramePublicAPI;
const selectFrameDatasourceAPI = (0, _toolkit.createSelector)([selectFramePublicAPI, selectExecutionContext], (framePublicAPI, context) => ({
  ...context,
  ...framePublicAPI
}));
exports.selectFrameDatasourceAPI = selectFrameDatasourceAPI;