"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutContainer = FlyoutContainer;
require("./flyout_container.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _utils = require("../utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function fromExcludedClickTarget(event) {
  for (let node = event.target; node !== null; node = node.parentElement) {
    if (node.classList.contains(_utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS) || node.classList.contains('euiBody-hasPortalContent') || node.getAttribute('data-euiportal') === 'true') {
      return true;
    }
  }
  return false;
}
function FlyoutContainer({
  isOpen,
  groupLabel,
  handleClose,
  isFullscreen,
  panelRef,
  panelContainerRef,
  children,
  customFooter
}) {
  const [focusTrapIsEnabled, setFocusTrapIsEnabled] = (0, _react.useState)(false);
  const closeFlyout = (0, _react.useCallback)(() => {
    const canClose = handleClose();
    if (canClose) {
      setFocusTrapIsEnabled(false);
    }
    return canClose;
  }, [handleClose]);
  (0, _react.useEffect)(() => {
    document.body.classList.toggle('lnsBody--overflowHidden', isOpen);
    return () => {
      if (isOpen) {
        setFocusTrapIsEnabled(false);
      }
      document.body.classList.remove('lnsBody--overflowHidden');
    };
  }, [isOpen]);
  if (!isOpen) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: panelRef
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    disabled: !focusTrapIsEnabled,
    clickOutsideDisables: false,
    onClickOutside: event => {
      if (isFullscreen || fromExcludedClickTarget(event)) {
        return;
      }
      closeFlyout();
    },
    onEscapeKey: closeFlyout
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: panelContainerRef,
    role: "dialog",
    "aria-labelledby": "lnsDimensionContainerTitle",
    className: "lnsDimensionContainer euiFlyout",
    onAnimationEnd: () => {
      if (isOpen) {
        // EuiFocusTrap interferes with animating elements with absolute position:
        // running this onAnimationEnd, otherwise the flyout pushes content when animating
        setFocusTrapIsEnabled(true);
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    className: "lnsDimensionContainer__header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "lnsDimensionContainerTitle",
    className: "lnsDimensionContainer__headerTitle"
  }, _i18n.i18n.translate('xpack.lens.configure.configurePanelTitle', {
    defaultMessage: '{groupLabel}',
    values: {
      groupLabel
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    "data-test-subj": "lns-indexPattern-dimensionContainerBack",
    className: "lnsDimensionContainer__backIcon",
    onClick: closeFlyout,
    iconType: "cross",
    "aria-label": _i18n.i18n.translate('xpack.lens.dimensionContainer.closeConfiguration', {
      defaultMessage: 'Close configuration'
    })
  })))), /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsDimensionContainer__content"
  }, children), customFooter || /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "lnsDimensionContainer__footer"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    flush: "left",
    size: "s",
    iconType: "cross",
    onClick: closeFlyout,
    "data-test-subj": "lns-indexPattern-dimensionContainerClose"
  }, _i18n.i18n.translate('xpack.lens.dimensionContainer.close', {
    defaultMessage: 'Close'
  }))))));
}