"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpressionWrapper = ExpressionWrapper;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _classnames = _interopRequireDefault(require("classnames"));
var _error_helper = require("../editor_frame_service/error_helper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ExpressionWrapper({
  ExpressionRenderer: ExpressionRendererComponent,
  expression,
  searchContext,
  variables,
  handleEvent,
  interactive,
  searchSessionId,
  onData$,
  onRender$,
  renderMode,
  syncColors,
  syncTooltips,
  syncCursor,
  hasCompatibleActions,
  getCompatibleCellValueActions,
  style,
  className,
  onRuntimeError,
  addUserMessages,
  executionContext,
  lensInspector,
  noPadding
}) {
  if (!expression) return null;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement("div", {
    className: (0, _classnames.default)('lnsExpressionRenderer', className),
    style: style
  }, /*#__PURE__*/_react.default.createElement(ExpressionRendererComponent, {
    className: "lnsExpressionRenderer__component",
    padding: noPadding ? undefined : 's',
    variables: variables,
    expression: expression,
    interactive: interactive,
    searchContext: searchContext,
    searchSessionId: searchSessionId,
    onData$: onData$,
    onRender$: onRender$,
    inspectorAdapters: lensInspector.adapters,
    renderMode: renderMode,
    syncColors: syncColors,
    syncTooltips: syncTooltips,
    syncCursor: syncCursor,
    executionContext: executionContext,
    renderError: (errorMessage, error) => {
      var _messages$;
      const messages = (0, _error_helper.getOriginalRequestErrorMessages)(error);
      addUserMessages(messages.map(message => ({
        uniqueId: message,
        severity: 'error',
        displayLocations: [{
          id: 'visualizationOnEmbeddable'
        }],
        longMessage: message,
        shortMessage: message,
        fixableInEditor: false
      })));
      onRuntimeError((_messages$ = messages[0]) !== null && _messages$ !== void 0 ? _messages$ : errorMessage);
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null); // the embeddable will take care of displaying the messages
    },

    onEvent: handleEvent,
    hasCompatibleActions: hasCompatibleActions,
    getCompatibleCellValueActions: getCompatibleCellValueActions
  })));
}