"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkspacePanel = exports.VisualizationWrapper = exports.InnerWorkspacePanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _classnames = _interopRequireDefault(require("classnames"));
var _i18nReact = require("@kbn/i18n-react");
var _interpreter = require("@kbn/interpreter");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/visualizations-plugin/public");
var _chartIcons = require("@kbn/chart-icons");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _lens_ui_telemetry = require("../../../lens_ui_telemetry");
var _utils = require("../../../utils");
var _types = require("../../../types");
var _suggestion_helpers = require("../suggestion_helpers");
var _expression_helpers = require("../expression_helpers");
var _workspace_panel_wrapper = require("./workspace_panel_wrapper");
var _render_dark2x = _interopRequireDefault(require("../../../assets/render_dark@2x.png"));
var _render_light2x = _interopRequireDefault(require("../../../assets/render_light@2x.png"));
var _error_helper = require("../../error_helper");
var _state_management = require("../../../state_management");
var _lens_slice = require("../../../state_management/lens_slice");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dropProps = {
  value: {
    id: 'lnsWorkspace',
    humanData: {
      label: _i18n.i18n.translate('xpack.lens.editorFrame.workspaceLabel', {
        defaultMessage: 'Workspace'
      })
    }
  },
  order: [1, 0, 0, 0]
};
const executionContext = {
  type: 'application',
  child: {
    type: 'lens'
  }
};
const EXPRESSION_BUILD_ERROR_ID = 'expression_build_error';
const WorkspacePanel = /*#__PURE__*/_react.default.memo(function WorkspacePanel(props) {
  const {
    getSuggestionForField,
    ...restProps
  } = props;
  const dragDropContext = (0, _react.useContext)(_domDragDrop.DragContext);
  const suggestionForDraggedField = (0, _react.useMemo)(() => dragDropContext.dragging && getSuggestionForField(dragDropContext.dragging), [dragDropContext.dragging, getSuggestionForField]);
  return /*#__PURE__*/_react.default.createElement(InnerWorkspacePanel, (0, _extends2.default)({}, restProps, {
    suggestionForDraggedField: suggestionForDraggedField
  }));
});

// Exported for testing purposes only.
exports.WorkspacePanel = WorkspacePanel;
const InnerWorkspacePanel = /*#__PURE__*/_react.default.memo(function InnerWorkspacePanel({
  framePublicAPI,
  visualizationMap,
  datasourceMap,
  core,
  plugins,
  ExpressionRenderer: ExpressionRendererComponent,
  suggestionForDraggedField,
  lensInspector,
  getUserMessages,
  addUserMessages
}) {
  const dispatchLens = (0, _state_management.useLensDispatch)();
  const isFullscreen = (0, _state_management.useLensSelector)(_state_management.selectIsFullscreenDatasource);
  const visualization = (0, _state_management.useLensSelector)(_state_management.selectVisualization);
  const activeDatasourceId = (0, _state_management.useLensSelector)(_state_management.selectActiveDatasourceId);
  const datasourceStates = (0, _state_management.useLensSelector)(_state_management.selectDatasourceStates);
  const autoApplyEnabled = (0, _state_management.useLensSelector)(_state_management.selectAutoApplyEnabled);
  const changesApplied = (0, _state_management.useLensSelector)(_state_management.selectChangesApplied);
  const triggerApply = (0, _state_management.useLensSelector)(_state_management.selectTriggerApplyChanges);
  const datasourceLayers = (0, _state_management.useLensSelector)(state => (0, _state_management.selectDatasourceLayers)(state, datasourceMap));
  const searchSessionId = (0, _state_management.useLensSelector)(_state_management.selectSearchSessionId);
  const [localState, setLocalState] = (0, _react.useState)({
    expandError: false,
    expressionToRender: undefined,
    errors: []
  });
  const initialRenderComplete = (0, _react.useRef)();
  const renderDeps = (0, _react.useRef)();
  const {
    dataViews
  } = framePublicAPI;
  renderDeps.current = {
    datasourceMap,
    datasourceStates,
    visualization,
    visualizationMap,
    datasourceLayers,
    dataViews
  };
  const onRender$ = (0, _react.useCallback)(() => {
    if (renderDeps.current) {
      const datasourceEvents = Object.values(renderDeps.current.datasourceMap).reduce((acc, datasource) => {
        var _datasource$getRender, _datasource$getRender2, _datasourceStates$dat;
        if (!renderDeps.current.datasourceStates[datasource.id]) return [];
        return [...acc, ...((_datasource$getRender = (_datasource$getRender2 = datasource.getRenderEventCounters) === null || _datasource$getRender2 === void 0 ? void 0 : _datasource$getRender2.call(datasource, (_datasourceStates$dat = renderDeps.current.datasourceStates[datasource.id]) === null || _datasourceStates$dat === void 0 ? void 0 : _datasourceStates$dat.state)) !== null && _datasource$getRender !== void 0 ? _datasource$getRender : [])];
      }, []);
      let visualizationEvents = [];
      if (renderDeps.current.visualization.activeId) {
        var _renderDeps$current$v, _renderDeps$current$v2, _renderDeps$current$v3;
        visualizationEvents = (_renderDeps$current$v = (_renderDeps$current$v2 = (_renderDeps$current$v3 = renderDeps.current.visualizationMap[renderDeps.current.visualization.activeId]).getRenderEventCounters) === null || _renderDeps$current$v2 === void 0 ? void 0 : _renderDeps$current$v2.call(_renderDeps$current$v3, renderDeps.current.visualization.state)) !== null && _renderDeps$current$v !== void 0 ? _renderDeps$current$v : [];
      }
      const events = ['vis_editor', ...datasourceEvents, ...visualizationEvents];
      const adHocDataViews = Object.values(renderDeps.current.dataViews.indexPatterns || {}).filter(indexPattern => !indexPattern.isPersisted);
      adHocDataViews.forEach(() => {
        events.push('ad_hoc_data_view');
      });
      (0, _lens_ui_telemetry.trackUiCounterEvents)(events);
    }
  }, []);
  const removeSearchWarningMessagesRef = (0, _react.useRef)();
  const removeExpressionBuildErrorsRef = (0, _react.useRef)();
  const onData$ = (0, _react.useCallback)((_data, adapters) => {
    if (renderDeps.current) {
      const [defaultLayerId] = Object.keys(renderDeps.current.datasourceLayers);
      const datasource = Object.values(renderDeps.current.datasourceMap)[0];
      const datasourceState = Object.values(renderDeps.current.datasourceStates)[0].state;
      let requestWarnings = [];
      if (adapters !== null && adapters !== void 0 && adapters.requests) {
        requestWarnings = (0, _utils.getSearchWarningMessages)(adapters.requests, datasource, datasourceState, {
          searchService: plugins.data.search
        });
      }
      if (requestWarnings.length) {
        removeSearchWarningMessagesRef.current = addUserMessages(requestWarnings.filter(_types.isMessageRemovable));
      } else if (removeSearchWarningMessagesRef.current) {
        removeSearchWarningMessagesRef.current();
        removeSearchWarningMessagesRef.current = undefined;
      }
      if (adapters && adapters.tables) {
        var _adapters$tables;
        dispatchLens((0, _state_management.onActiveDataChange)({
          activeData: Object.entries((_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : _adapters$tables.tables).reduce((acc, [key, value], _index, tables) => ({
            ...acc,
            [tables.length === 1 ? defaultLayerId : key]: value
          }), {})
        }));
      }
    }
  }, [addUserMessages, dispatchLens, plugins.data.search]);
  const shouldApplyExpression = autoApplyEnabled || !initialRenderComplete.current || triggerApply;
  const activeVisualization = visualization.activeId ? visualizationMap[visualization.activeId] : null;
  const workspaceErrors = (0, _react.useCallback)(() => {
    return getUserMessages(['visualization', 'visualizationInEditor'], {
      severity: 'error'
    });
  }, [getUserMessages]);

  // if the expression is undefined, it means we hit an error that should be displayed to the user
  const unappliedExpression = (0, _react.useMemo)(() => {
    // shouldn't build expression if there is any type of error other than an expression build error
    // (in which case we try again every time because the config might have changed)
    if (workspaceErrors().every(error => error.uniqueId === EXPRESSION_BUILD_ERROR_ID)) {
      try {
        const ast = (0, _expression_helpers.buildExpression)({
          visualization: activeVisualization,
          visualizationState: visualization.state,
          datasourceMap,
          datasourceStates,
          datasourceLayers,
          indexPatterns: dataViews.indexPatterns,
          dateRange: framePublicAPI.dateRange,
          nowInstant: plugins.data.nowProvider.get(),
          searchSessionId
        });
        if (ast) {
          // expression has to be turned into a string for dirty checking - if the ast is rebuilt,
          // turning it into a string will make sure the expression renderer only re-renders if the
          // expression actually changed.
          return (0, _interpreter.toExpression)(ast);
        } else {
          return null;
        }
      } catch (e) {
        removeExpressionBuildErrorsRef.current = addUserMessages([{
          uniqueId: EXPRESSION_BUILD_ERROR_ID,
          severity: 'error',
          fixableInEditor: true,
          displayLocations: [{
            id: 'visualization'
          }],
          shortMessage: _i18n.i18n.translate('xpack.lens.editorFrame.buildExpressionError', {
            defaultMessage: 'An unexpected error occurred while preparing the chart'
          }),
          longMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
            "data-test-subj": "expression-failure"
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.lens.editorFrame.expressionFailure",
            defaultMessage: "An error occurred in the expression"
          })), /*#__PURE__*/_react.default.createElement("p", null, e.toString()))
        }]);
      }
    }
  }, [workspaceErrors, activeVisualization, visualization.state, datasourceMap, datasourceStates, datasourceLayers, dataViews.indexPatterns, framePublicAPI.dateRange, plugins.data.nowProvider, searchSessionId, addUserMessages]);
  (0, _react.useEffect)(() => {
    dispatchLens((0, _state_management.setSaveable)(Boolean(unappliedExpression)));
  }, [unappliedExpression, dispatchLens]);
  (0, _react.useEffect)(() => {
    if (!autoApplyEnabled) {
      dispatchLens((0, _lens_slice.setChangesApplied)(unappliedExpression === localState.expressionToRender));
    }
  });
  (0, _react.useEffect)(() => {
    if (shouldApplyExpression) {
      setLocalState(s => ({
        ...s,
        expressionToRender: unappliedExpression,
        errors: workspaceErrors()
      }));
    }
  }, [unappliedExpression, shouldApplyExpression, workspaceErrors]);
  const expressionExists = Boolean(localState.expressionToRender);
  (0, _react.useEffect)(() => {
    // reset expression error if component attempts to run it again
    if (expressionExists && removeExpressionBuildErrorsRef.current) {
      removeExpressionBuildErrorsRef.current();
      removeExpressionBuildErrorsRef.current = undefined;
    }
  }, [expressionExists]);
  (0, _react.useEffect)(() => {
    // null signals an empty workspace which should count as an initial render
    if ((expressionExists || localState.expressionToRender === null) && !initialRenderComplete.current) {
      initialRenderComplete.current = true;
    }
  }, [expressionExists, localState.expressionToRender]);
  const onEvent = (0, _react.useCallback)(event => {
    if (!plugins.uiActions) {
      // ui actions not available, not handling event...
      return;
    }
    if ((0, _types.isLensBrushEvent)(event)) {
      plugins.uiActions.getTrigger(_public.VIS_EVENT_TO_TRIGGER[event.name]).exec({
        data: {
          ...event.data,
          timeFieldName: (0, _utils.inferTimeField)(plugins.data.datatableUtilities, event.data)
        }
      });
    }
    if ((0, _types.isLensFilterEvent)(event) || (0, _types.isLensMultiFilterEvent)(event)) {
      plugins.uiActions.getTrigger(_public.VIS_EVENT_TO_TRIGGER[event.name]).exec({
        data: {
          ...event.data,
          timeFieldName: (0, _utils.inferTimeField)(plugins.data.datatableUtilities, event.data)
        }
      });
    }
    if ((0, _types.isLensEditEvent)(event) && activeVisualization !== null && activeVisualization !== void 0 && activeVisualization.onEditAction) {
      dispatchLens((0, _state_management.editVisualizationAction)({
        visualizationId: activeVisualization.id,
        event
      }));
    }
  }, [plugins.data.datatableUtilities, plugins.uiActions, activeVisualization, dispatchLens]);
  const hasCompatibleActions = (0, _react.useCallback)(async event => {
    if (!plugins.uiActions) {
      // ui actions not available, not handling event...
      return false;
    }
    if (!(0, _types.isLensFilterEvent)(event) && !(0, _types.isLensMultiFilterEvent)(event)) {
      return false;
    }
    return (await plugins.uiActions.getTriggerCompatibleActions(_public.VIS_EVENT_TO_TRIGGER[event.name], event)).length > 0;
  }, [plugins.uiActions]);
  const onDrop = (0, _react.useCallback)(() => {
    if (suggestionForDraggedField) {
      (0, _lens_ui_telemetry.trackUiCounterEvents)('drop_onto_workspace');
      (0, _suggestion_helpers.switchToSuggestion)(dispatchLens, suggestionForDraggedField, {
        clearStagedPreview: true
      });
    }
  }, [suggestionForDraggedField, dispatchLens]);
  const IS_DARK_THEME = (0, _useObservable.default)(core.theme.theme$, {
    darkMode: false
  }).darkMode;
  const renderDragDropPrompt = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: (0, _classnames.default)('lnsWorkspacePanel__emptyContent'),
      textAlign: "center",
      "data-test-subj": "workspace-drag-drop-prompt",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_chartIcons.DropIllustration, {
      "aria-hidden": true,
      className: (0, _classnames.default)('lnsWorkspacePanel__promptIllustration', 'lnsWorkspacePanel__dropIllustration')
    }), /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement("strong", null, !expressionExists ? _i18n.i18n.translate('xpack.lens.editorFrame.emptyWorkspace', {
      defaultMessage: 'Drop some fields here to start'
    }) : _i18n.i18n.translate('xpack.lens.editorFrame.emptyWorkspaceSimple', {
      defaultMessage: 'Drop field here'
    }))), !expressionExists && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      component: "div"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.lens.editorFrame.emptyWorkspaceHeading', {
      defaultMessage: 'Lens is the recommended editor for creating visualizations'
    }))), /*#__PURE__*/_react.default.createElement("p", {
      className: "lnsWorkspacePanel__actions"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: "https://www.elastic.co/products/kibana/feedback",
      target: "_blank",
      external: true
    }, _i18n.i18n.translate('xpack.lens.editorFrame.goToForums', {
      defaultMessage: 'Make requests and give feedback'
    }))))));
  };
  const renderApplyChangesPrompt = () => {
    const applyChangesString = _i18n.i18n.translate('xpack.lens.editorFrame.applyChanges', {
      defaultMessage: 'Apply changes'
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      className: (0, _classnames.default)('lnsWorkspacePanel__emptyContent'),
      textAlign: "center",
      "data-test-subj": "workspace-apply-changes-prompt",
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("img", {
      "aria-hidden": true,
      src: IS_DARK_THEME ? _render_dark2x.default : _render_light2x.default,
      alt: applyChangesString,
      className: "lnsWorkspacePanel__promptIllustration"
    }), /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.lens.editorFrame.applyChangesWorkspacePrompt', {
      defaultMessage: 'Apply changes to render visualization'
    }))), /*#__PURE__*/_react.default.createElement("p", {
      className: "lnsWorkspacePanel__actions"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      className: _utils.DONT_CLOSE_DIMENSION_CONTAINER_ON_CLICK_CLASS,
      iconType: "checkInCircleFilled",
      onClick: () => dispatchLens((0, _state_management.applyChanges)()),
      "data-test-subj": "lnsApplyChanges__workspace"
    }, applyChangesString))));
  };
  const renderVisualization = () => {
    return /*#__PURE__*/_react.default.createElement(VisualizationWrapper, {
      expression: localState.expressionToRender,
      framePublicAPI: framePublicAPI,
      lensInspector: lensInspector,
      onEvent: onEvent,
      hasCompatibleActions: hasCompatibleActions,
      setLocalState: setLocalState,
      localState: {
        ...localState
      },
      errors: localState.errors,
      ExpressionRendererComponent: ExpressionRendererComponent,
      core: core,
      activeDatasourceId: activeDatasourceId,
      onRender$: onRender$,
      onData$: onData$
    });
  };
  const dragDropContext = (0, _react.useContext)(_domDragDrop.DragContext);
  const renderWorkspace = () => {
    var _datasourceMap$active;
    const customWorkspaceRenderer = activeDatasourceId && (_datasourceMap$active = datasourceMap[activeDatasourceId]) !== null && _datasourceMap$active !== void 0 && _datasourceMap$active.getCustomWorkspaceRenderer && dragDropContext.dragging ? datasourceMap[activeDatasourceId].getCustomWorkspaceRenderer(datasourceStates[activeDatasourceId].state, dragDropContext.dragging, dataViews.indexPatterns) : undefined;
    if (customWorkspaceRenderer) {
      return customWorkspaceRenderer();
    }
    const hasSomethingToRender = localState.expressionToRender !== null;
    const renderWorkspaceContents = hasSomethingToRender ? renderVisualization : !changesApplied ? renderApplyChangesPrompt : renderDragDropPrompt;
    return /*#__PURE__*/_react.default.createElement(_domDragDrop.DragDrop, {
      className: (0, _classnames.default)('lnsWorkspacePanel__dragDrop', {
        'lnsWorkspacePanel__dragDrop--fullscreen': isFullscreen
      }),
      dataTestSubj: "lnsWorkspace",
      draggable: false,
      dropTypes: suggestionForDraggedField ? ['field_add'] : undefined,
      onDrop: onDrop,
      value: dropProps.value,
      order: dropProps.order
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "lnsWorkspacePanelWrapper__pageContentBody"
    }, renderWorkspaceContents()));
  };
  return /*#__PURE__*/_react.default.createElement(_workspace_panel_wrapper.WorkspacePanelWrapper, {
    framePublicAPI: framePublicAPI,
    visualizationState: visualization.state,
    visualizationId: visualization.activeId,
    datasourceStates: datasourceStates,
    datasourceMap: datasourceMap,
    visualizationMap: visualizationMap,
    isFullscreen: isFullscreen,
    lensInspector: lensInspector,
    getUserMessages: getUserMessages
  }, renderWorkspace());
});
exports.InnerWorkspacePanel = InnerWorkspacePanel;
function useReportingState(errors) {
  const [isRenderComplete, setIsRenderComplete] = (0, _react.useState)(Boolean(errors === null || errors === void 0 ? void 0 : errors.length));
  const [hasDynamicError, setDynamicError] = (0, _react.useState)(false);
  const nodeRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    if (isRenderComplete && nodeRef.current) {
      nodeRef.current.dispatchEvent(new CustomEvent('renderComplete', {
        bubbles: true
      }));
    }
  }, [isRenderComplete, errors]);
  return {
    isRenderComplete,
    setIsRenderComplete,
    hasDynamicError,
    setDynamicError,
    nodeRef
  };
}
const VisualizationWrapper = ({
  expression,
  framePublicAPI,
  lensInspector,
  onEvent,
  hasCompatibleActions,
  setLocalState,
  localState,
  errors,
  ExpressionRendererComponent,
  core,
  activeDatasourceId,
  onRender$,
  onData$
}) => {
  const context = (0, _state_management.useLensSelector)(_state_management.selectExecutionContext);
  // Used for reporting
  const {
    isRenderComplete,
    hasDynamicError,
    setIsRenderComplete,
    setDynamicError,
    nodeRef
  } = useReportingState(errors);
  const searchContext = (0, _react.useMemo)(() => ({
    query: context.query,
    timeRange: {
      from: context.dateRange.fromDate,
      to: context.dateRange.toDate
    },
    filters: context.filters,
    disableShardWarnings: true
  }), [context]);
  const searchSessionId = (0, _state_management.useLensSelector)(_state_management.selectSearchSessionId);
  if (errors.length) {
    const showExtraErrorsAction = !localState.expandError && errors.length > 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: () => {
        setLocalState(prevState => ({
          ...prevState,
          expandError: !prevState.expandError
        }));
      },
      "data-test-subj": "workspace-more-errors-button"
    }, _i18n.i18n.translate('xpack.lens.editorFrame.configurationFailureMoreErrors', {
      defaultMessage: ` +{errors} {errors, plural, one {error} other {errors}}`,
      values: {
        errors: errors.length - 1
      }
    })) : null;
    const [firstMessage, ...rest] = errors;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      "data-shared-items-container": true,
      "data-render-complete": true,
      "data-shared-item": "",
      "data-render-error": _i18n.i18n.translate('xpack.lens.editorFrame.configurationFailureErrors', {
        defaultMessage: `A configuration error occurred`
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      actions: showExtraErrorsAction,
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "workspace-error-message"
      }, firstMessage.longMessage), localState.expandError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), rest.map(message => /*#__PURE__*/_react.default.createElement("div", {
        "data-test-subj": "workspace-error-message"
      }, message.longMessage, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null))))),
      iconColor: "danger",
      iconType: "warning"
    })));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsExpressionRenderer",
    "data-shared-items-container": true,
    "data-render-complete": isRenderComplete,
    "data-shared-item": "",
    "data-render-error": hasDynamicError ? _i18n.i18n.translate('xpack.lens.editorFrame.dataFailure', {
      defaultMessage: `An error occurred when loading data.`
    }) : undefined,
    ref: nodeRef
  }, /*#__PURE__*/_react.default.createElement(ExpressionRendererComponent, {
    className: "lnsExpressionRenderer__component",
    padding: "m",
    expression: expression,
    searchContext: searchContext,
    searchSessionId: searchSessionId,
    onEvent: onEvent,
    hasCompatibleActions: hasCompatibleActions,
    onData$: onData$,
    onRender$: () => {
      setIsRenderComplete(true);
      onRender$();
    },
    inspectorAdapters: lensInspector.adapters,
    executionContext: executionContext,
    renderMode: "edit",
    renderError: (errorMessage, error) => {
      const errorsFromRequest = (0, _error_helper.getOriginalRequestErrorMessages)(error);
      const visibleErrorMessages = errorsFromRequest.length ? errorsFromRequest : errorMessage ? [errorMessage] : [];
      if (!hasDynamicError) {
        setDynamicError(true);
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        actions: visibleErrorMessages.length && !localState.expandError ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
          onClick: () => {
            setLocalState(prevState => ({
              ...prevState,
              expandError: !prevState.expandError
            }));
          }
        }, _i18n.i18n.translate('xpack.lens.editorFrame.expandRenderingErrorButton', {
          defaultMessage: 'Show details of error'
        })) : null,
        body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
          "data-test-subj": "expression-failure"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.lens.editorFrame.dataFailure",
          defaultMessage: "An error occurred when loading data."
        })), localState.expandError ? visibleErrorMessages.map(visibleErrorMessage => /*#__PURE__*/_react.default.createElement("p", {
          className: "eui-textBreakWord",
          key: visibleErrorMessage
        }, visibleErrorMessage)) : null),
        iconColor: "danger",
        iconType: "warning"
      })));
    }
  }));
};
exports.VisualizationWrapper = VisualizationWrapper;