"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyDimensionButton = EmptyDimensionButton;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _domDragDrop = require("@kbn/dom-drag-drop");
var _public = require("@kbn/visualization-ui-components/public");
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _utils = require("../../../../utils");
var _id_generator = require("../../../../id_generator");
var _types = require("../../../../types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultButtonLabels = {
  ariaLabel: l => _i18n.i18n.translate('xpack.lens.indexPattern.addColumnAriaLabel', {
    defaultMessage: 'Add or drag-and-drop a field to {groupLabel}',
    values: {
      groupLabel: l
    }
  }),
  label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.configure.emptyConfig",
    defaultMessage: "Add or drag-and-drop a field"
  })
};
const DefaultEmptyButton = ({
  columnId,
  group,
  onClick
}) => {
  const {
    buttonAriaLabel,
    buttonLabel
  } = group.labels || {};
  return /*#__PURE__*/_react.default.createElement(_public.EmptyDimensionButton, {
    label: buttonLabel || defaultButtonLabels.label,
    ariaLabel: buttonAriaLabel || defaultButtonLabels.ariaLabel(group.groupLabel),
    dataTestSubj: "lns-empty-dimension",
    onClick: () => onClick(columnId)
  });
};
const SuggestedValueButton = ({
  columnId,
  group,
  onClick
}) => {
  var _group$suggestedValue, _group$suggestedValue2;
  return /*#__PURE__*/_react.default.createElement(_public.EmptyDimensionButton, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.configure.suggestedValuee",
      defaultMessage: "Suggested value: {value}",
      values: {
        value: (_group$suggestedValue = group.suggestedValue) === null || _group$suggestedValue === void 0 ? void 0 : _group$suggestedValue.call(group)
      }
    }),
    ariaLabel: _i18n.i18n.translate('xpack.lens.indexPattern.suggestedValueAriaLabel', {
      defaultMessage: 'Suggested value: {value} for {groupLabel}',
      values: {
        value: (_group$suggestedValue2 = group.suggestedValue) === null || _group$suggestedValue2 === void 0 ? void 0 : _group$suggestedValue2.call(group),
        groupLabel: group.groupLabel
      }
    }),
    dataTestSubj: "lns-empty-dimension-suggested-value",
    iconType: "plusInCircleFilled",
    onClick: () => onClick(columnId)
  });
};
function EmptyDimensionButton({
  group,
  layerDatasource,
  state,
  onClick,
  onDrop,
  datasourceLayers,
  indexPatterns,
  activeVisualization,
  order,
  target
}) {
  var _getDropProps, _group$suggestedValue3;
  const {
    dragging
  } = (0, _react.useContext)(_domDragDrop.DragContext);
  let getDropProps;
  if (dragging) {
    var _datasourceLayers$dra, _datasourceLayers$tar;
    if (!layerDatasource) {
      getDropProps = activeVisualization.getDropProps;
    } else if ((0, _utils.isDraggedField)(dragging) || (0, _types.isOperation)(dragging) && layerDatasource && (datasourceLayers === null || datasourceLayers === void 0 ? void 0 : (_datasourceLayers$dra = datasourceLayers[dragging.layerId]) === null || _datasourceLayers$dra === void 0 ? void 0 : _datasourceLayers$dra.datasourceId) === (datasourceLayers === null || datasourceLayers === void 0 ? void 0 : (_datasourceLayers$tar = datasourceLayers[target.layerId]) === null || _datasourceLayers$tar === void 0 ? void 0 : _datasourceLayers$tar.datasourceId)) {
      getDropProps = layerDatasource.getDropProps;
    }
  }
  const [newColumnId, setNewColumnId] = (0, _react.useState)((0, _id_generator.generateId)());
  (0, _react.useEffect)(() => {
    setNewColumnId((0, _id_generator.generateId)());
  }, [group.accessors.length]);
  const {
    dropTypes,
    nextLabel
  } = ((_getDropProps = getDropProps) === null || _getDropProps === void 0 ? void 0 : _getDropProps({
    state,
    source: dragging,
    target: {
      ...target,
      columnId: newColumnId
    },
    indexPatterns
  })) || {
    dropTypes: [],
    nextLabel: ''
  };
  const canDuplicate = !!(dropTypes.includes('duplicate_compatible') || dropTypes.includes('duplicate_incompatible'));
  const value = (0, _react.useMemo)(() => ({
    ...target,
    columnId: newColumnId,
    id: newColumnId,
    humanData: {
      ...target.humanData,
      nextLabel: nextLabel || '',
      canDuplicate
    }
  }), [newColumnId, target, nextLabel, canDuplicate]);
  const handleOnDrop = _react.default.useCallback((source, selectedDropType) => onDrop(source, value, selectedDropType), [value, onDrop]);
  const buttonProps = {
    columnId: value.columnId,
    onClick,
    group
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsLayerPanel__dimensionContainer",
    "data-test-subj": group.dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_domDragDrop.DragDrop, {
    getCustomDropTarget: _domDragDrop.DropTargetSwapDuplicateCombine.getCustomDropTarget,
    getAdditionalClassesOnDroppable: _domDragDrop.DropTargetSwapDuplicateCombine.getAdditionalClassesOnDroppable,
    value: value,
    order: order,
    onDrop: handleOnDrop,
    dropTypes: dropTypes
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
            border-radius: ${_uiTheme.euiThemeVars.euiBorderRadius};
          `
  }, typeof ((_group$suggestedValue3 = group.suggestedValue) === null || _group$suggestedValue3 === void 0 ? void 0 : _group$suggestedValue3.call(group)) === 'number' ? /*#__PURE__*/_react.default.createElement(SuggestedValueButton, buttonProps) : /*#__PURE__*/_react.default.createElement(DefaultEmptyButton, buttonProps))));
}