"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAllColumns = void 0;
exports.getIndexPatternFromTextBasedQuery = getIndexPatternFromTextBasedQuery;
exports.getStateFromAggregateQuery = getStateFromAggregateQuery;
exports.loadIndexPatternRefs = loadIndexPatternRefs;
var _esQuery = require("@kbn/es-query");
var _id_generator = require("../../id_generator");
var _fetch_data_from_aggregate_query = require("./fetch_data_from_aggregate_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function loadIndexPatternRefs(indexPatternsService) {
  const indexPatterns = await indexPatternsService.getIdsWithTitle();
  const timefields = await Promise.all(indexPatterns.map(p => indexPatternsService.get(p.id).then(pat => pat.timeFieldName)));
  return indexPatterns.map((p, i) => ({
    ...p,
    timeField: timefields[i]
  })).sort((a, b) => {
    return a.title.localeCompare(b.title);
  });
}
const getAllColumns = (existingColumns, columnsFromQuery) => {
  // filter out columns that do not exist on the query
  const columns = existingColumns.filter(c => {
    const columnExists = columnsFromQuery === null || columnsFromQuery === void 0 ? void 0 : columnsFromQuery.some(f => f.name === (c === null || c === void 0 ? void 0 : c.fieldName));
    if (columnExists) return c;
  });
  const allCols = [...columns, ...columnsFromQuery.map(c => ({
    columnId: c.id,
    fieldName: c.id,
    meta: c.meta
  }))];
  const uniqueIds = [];
  return allCols.filter(col => {
    const isDuplicate = uniqueIds.includes(col.columnId);
    if (!isDuplicate) {
      uniqueIds.push(col.columnId);
      return true;
    }
    return false;
  });
};
exports.getAllColumns = getAllColumns;
async function getStateFromAggregateQuery(state, query, dataViews, data, expressions, frameDataViews) {
  var _indexPatternRefs$fin, _indexPatternRefs$fin2, _state$layers$newLaye, _columnsFromQuery;
  let indexPatternRefs = frameDataViews !== null && frameDataViews !== void 0 && frameDataViews.indexPatternRefs.length ? frameDataViews.indexPatternRefs : await loadIndexPatternRefs(dataViews);
  const errors = [];
  const layerIds = Object.keys(state.layers);
  const context = state.initialContext;
  const newLayerId = layerIds.length > 0 ? layerIds[0] : (0, _id_generator.generateId)();
  // fetch the pattern from the query
  const indexPattern = getIndexPatternFromTextBasedQuery(query);
  // get the id of the dataview
  let dataViewId = (_indexPatternRefs$fin = (_indexPatternRefs$fin2 = indexPatternRefs.find(r => r.title === indexPattern)) === null || _indexPatternRefs$fin2 === void 0 ? void 0 : _indexPatternRefs$fin2.id) !== null && _indexPatternRefs$fin !== void 0 ? _indexPatternRefs$fin : '';
  let columnsFromQuery = [];
  let allColumns = [];
  let timeFieldName;
  try {
    var _table$columns;
    const dataView = await dataViews.create({
      title: indexPattern
    });
    if (dataView && dataView.id) {
      var _dataView$fields, _dataView$fields$getB;
      if ((dataView === null || dataView === void 0 ? void 0 : (_dataView$fields = dataView.fields) === null || _dataView$fields === void 0 ? void 0 : (_dataView$fields$getB = _dataView$fields.getByName('@timestamp')) === null || _dataView$fields$getB === void 0 ? void 0 : _dataView$fields$getB.type) === 'date') {
        dataView.timeFieldName = '@timestamp';
      }
      dataViewId = dataView === null || dataView === void 0 ? void 0 : dataView.id;
      indexPatternRefs = [...indexPatternRefs, {
        id: dataView.id,
        title: dataView.name,
        timeField: dataView.timeFieldName
      }];
    }
    timeFieldName = dataView.timeFieldName;
    const table = await (0, _fetch_data_from_aggregate_query.fetchDataFromAggregateQuery)(query, dataView, data, expressions);
    columnsFromQuery = (_table$columns = table === null || table === void 0 ? void 0 : table.columns) !== null && _table$columns !== void 0 ? _table$columns : [];
    allColumns = getAllColumns(state.layers[newLayerId].allColumns, columnsFromQuery);
  } catch (e) {
    errors.push(e);
  }
  const tempState = {
    layers: {
      [newLayerId]: {
        index: dataViewId,
        query,
        columns: (_state$layers$newLaye = state.layers[newLayerId].columns) !== null && _state$layers$newLaye !== void 0 ? _state$layers$newLaye : [],
        allColumns,
        timeField: timeFieldName,
        errors
      }
    }
  };
  return {
    ...tempState,
    fieldList: (_columnsFromQuery = columnsFromQuery) !== null && _columnsFromQuery !== void 0 ? _columnsFromQuery : [],
    indexPatternRefs,
    initialContext: context
  };
}
function getIndexPatternFromTextBasedQuery(query) {
  let indexPattern = '';
  // sql queries
  if ('sql' in query) {
    indexPattern = (0, _esQuery.getIndexPatternFromSQLQuery)(query.sql);
  }
  // other textbased queries....

  return indexPattern;
}