"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sumOperation = exports.standardDeviationOperation = exports.minOperation = exports.medianOperation = exports.maxOperation = exports.averageOperation = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _public = require("@kbn/expressions-plugin/public");
var _helpers = require("./helpers");
var _time_scale_utils = require("../time_scale_utils");
var _layer_helpers = require("../layer_helpers");
var _reduced_time_range_utils = require("../../reduced_time_range_utils");
var _get_group_by_key = require("./get_group_by_key");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const typeToFn = {
  min: 'aggMin',
  max: 'aggMax',
  average: 'aggAvg',
  sum: 'aggSum',
  median: 'aggMedian',
  standard_deviation: 'aggStdDeviation'
};
const supportedTypes = ['number', 'histogram'];
function isTimeSeriesCompatible(type, timeSeriesMetric) {
  return timeSeriesMetric !== 'counter' || ['min', 'max'].includes(type);
}
function buildMetricOperation({
  type,
  displayName,
  description,
  ofName,
  priority,
  optionalTimeScaling,
  supportsDate,
  hideZeroOption,
  aggConfigParams,
  documentationDescription,
  quickFunctionDocumentation,
  unsupportedSettings
}) {
  const labelLookup = (name, column) => {
    const label = ofName(name);
    return (0, _time_scale_utils.adjustTimeScaleLabelSuffix)(label, undefined, optionalTimeScaling ? column === null || column === void 0 ? void 0 : column.timeScale : undefined, undefined, column === null || column === void 0 ? void 0 : column.timeShift, undefined, column === null || column === void 0 ? void 0 : column.reducedTimeRange);
  };
  return {
    type,
    allowAsReference: true,
    priority,
    displayName,
    description,
    input: 'field',
    timeScalingMode: optionalTimeScaling ? 'optional' : undefined,
    getUnsupportedSettings: () => unsupportedSettings,
    getPossibleOperationForField: ({
      aggregationRestrictions,
      aggregatable,
      type: fieldType,
      timeSeriesMetric
    }) => {
      if ((supportedTypes.includes(fieldType) || supportsDate && fieldType === 'date') && aggregatable && isTimeSeriesCompatible(type, timeSeriesMetric) && (!aggregationRestrictions || aggregationRestrictions[type])) {
        return {
          dataType: fieldType === 'date' ? 'date' : 'number',
          isBucketed: false,
          scale: 'ratio'
        };
      }
    },
    isTransferable: (column, newIndexPattern) => {
      const newField = newIndexPattern.getFieldByName(column.sourceField);
      return Boolean(newField && supportedTypes.includes(newField.type) && newField.aggregatable && isTimeSeriesCompatible(type, newField.timeSeriesMetric) && (!newField.aggregationRestrictions || newField.aggregationRestrictions[type]));
    },
    getDefaultLabel: (column, indexPattern, columns) => labelLookup((0, _helpers.getSafeName)(column.sourceField, indexPattern), column),
    buildColumn: ({
      field,
      previousColumn
    }, columnParams) => {
      var _previousColumn$param;
      return {
        label: labelLookup(field.displayName, previousColumn),
        dataType: supportsDate && field.type === 'date' ? 'date' : 'number',
        operationType: type,
        sourceField: field.name,
        isBucketed: false,
        scale: 'ratio',
        timeScale: optionalTimeScaling ? previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeScale : undefined,
        filter: (0, _helpers.getFilter)(previousColumn, columnParams),
        timeShift: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.shift) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.timeShift),
        reducedTimeRange: (columnParams === null || columnParams === void 0 ? void 0 : columnParams.reducedTimeRange) || (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.reducedTimeRange),
        params: {
          ...(0, _helpers.getFormatFromPreviousColumn)(previousColumn),
          emptyAsNull: hideZeroOption && previousColumn && (0, _helpers.isColumnOfType)(type, previousColumn) ? (_previousColumn$param = previousColumn.params) === null || _previousColumn$param === void 0 ? void 0 : _previousColumn$param.emptyAsNull : !(columnParams !== null && columnParams !== void 0 && columnParams.usedInMath)
        }
      };
    },
    onFieldChange: (oldColumn, field) => {
      return {
        ...oldColumn,
        label: labelLookup(field.displayName, oldColumn),
        dataType: field.type,
        sourceField: field.name
      };
    },
    getAdvancedOptions: ({
      layer,
      columnId,
      currentColumn,
      paramEditorUpdater
    }) => {
      var _currentColumn$params;
      if (!hideZeroOption) return [];
      return [{
        dataTestSubj: 'hide-zero-values',
        inlineElement: /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
          label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "xs"
          }, _i18n.i18n.translate('xpack.lens.indexPattern.hideZero', {
            defaultMessage: 'Hide zero values'
          })),
          labelProps: {
            style: {
              fontWeight: _uiTheme.euiThemeVars.euiFontWeightMedium
            }
          },
          checked: Boolean((_currentColumn$params = currentColumn.params) === null || _currentColumn$params === void 0 ? void 0 : _currentColumn$params.emptyAsNull),
          onChange: () => {
            var _currentColumn$params2;
            paramEditorUpdater((0, _layer_helpers.updateColumnParam)({
              layer,
              columnId,
              paramName: 'emptyAsNull',
              value: !((_currentColumn$params2 = currentColumn.params) !== null && _currentColumn$params2 !== void 0 && _currentColumn$params2.emptyAsNull)
            }));
          },
          compressed: true
        })
      }];
    },
    toEsAggsFn: (column, columnId, _indexPattern) => {
      var _column$params;
      return (0, _public.buildExpressionFunction)(typeToFn[type], {
        id: columnId,
        enabled: true,
        schema: 'metric',
        field: column.sourceField,
        // time shift is added to wrapping aggFilteredMetric if filter is set
        timeShift: column.filter ? undefined : column.timeShift,
        emptyAsNull: hideZeroOption ? (_column$params = column.params) === null || _column$params === void 0 ? void 0 : _column$params.emptyAsNull : undefined,
        ...aggConfigParams
      }).toAst();
    },
    getGroupByKey: agg => {
      return (0, _get_group_by_key.getGroupByKey)(agg, [typeToFn[type]], [{
        name: 'field'
      }, {
        name: 'emptyAsNull',
        transformer: val => String(Boolean(val))
      }]);
    },
    getErrorMessage: (layer, columnId, indexPattern) => (0, _helpers.combineErrorMessages)([(0, _helpers.getInvalidFieldMessage)(layer, columnId, indexPattern), (0, _reduced_time_range_utils.getColumnReducedTimeRangeError)(layer, columnId, indexPattern)]),
    filterable: true,
    canReduceTimeRange: true,
    documentation: {
      section: 'elasticsearch',
      signature: _i18n.i18n.translate('xpack.lens.indexPattern.metric.signature', {
        defaultMessage: 'field: string'
      }),
      description: documentationDescription || _i18n.i18n.translate('xpack.lens.indexPattern.metric.documentation.markdown', {
        defaultMessage: `
Returns the {metric} of a field. This function only works for number fields.

Example: Get the {metric} of price:
\`{metric}(price)\`

Example: Get the {metric} of price for orders from the UK:
\`{metric}(price, kql='location:UK')\`
      `,
        values: {
          metric: type
        }
      })
    },
    quickFunctionDocumentation,
    shiftable: true
  };
}
const minOperation = buildMetricOperation({
  type: 'min',
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.min', {
    defaultMessage: 'Minimum'
  }),
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.minOf', {
    defaultMessage: 'Minimum of {name}',
    values: {
      name
    }
  }),
  description: _i18n.i18n.translate('xpack.lens.indexPattern.min.description', {
    defaultMessage: 'A single-value metrics aggregation that returns the minimum value among the numeric values extracted from the aggregated documents.'
  }),
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.min.quickFunctionDescription', {
    defaultMessage: 'The minimum value of a number field.'
  }),
  supportsDate: true,
  unsupportedSettings: {
    sampling: false
  }
});
exports.minOperation = minOperation;
const maxOperation = buildMetricOperation({
  type: 'max',
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.max', {
    defaultMessage: 'Maximum'
  }),
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.maxOf', {
    defaultMessage: 'Maximum of {name}',
    values: {
      name
    }
  }),
  description: _i18n.i18n.translate('xpack.lens.indexPattern.max.description', {
    defaultMessage: 'A single-value metrics aggregation that returns the maximum value among the numeric values extracted from the aggregated documents.'
  }),
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.max.quickFunctionDescription', {
    defaultMessage: 'The maximum value of a number field.'
  }),
  supportsDate: true,
  unsupportedSettings: {
    sampling: false
  }
});
exports.maxOperation = maxOperation;
const averageOperation = buildMetricOperation({
  type: 'average',
  priority: 2,
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.avg', {
    defaultMessage: 'Average'
  }),
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.avgOf', {
    defaultMessage: 'Average of {name}',
    values: {
      name
    }
  }),
  description: _i18n.i18n.translate('xpack.lens.indexPattern.avg.description', {
    defaultMessage: 'A single-value metric aggregation that computes the average of numeric values that are extracted from the aggregated documents'
  }),
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.avg.quickFunctionDescription', {
    defaultMessage: 'The mean value of a set of number fields.'
  })
});
exports.averageOperation = averageOperation;
const standardDeviationOperation = buildMetricOperation({
  type: 'standard_deviation',
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.standardDeviation', {
    defaultMessage: 'Standard deviation'
  }),
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.standardDeviationOf', {
    defaultMessage: 'Standard deviation of {name}',
    values: {
      name
    }
  }),
  description: _i18n.i18n.translate('xpack.lens.indexPattern.standardDeviation.description', {
    defaultMessage: 'A single-value metric aggregation that computes the standard deviation of numeric values that are extracted from the aggregated documents'
  }),
  aggConfigParams: {
    showBounds: false
  },
  documentationDescription: _i18n.i18n.translate('xpack.lens.indexPattern.standardDeviation.documentation.markdown', {
    defaultMessage: `
Returns the amount of variation or dispersion of the field. The function works only for number fields.

#### Examples

To get the standard deviation of price, use \`standard_deviation(price)\`.

To get the variance of price for orders from the UK, use \`square(standard_deviation(price, kql='location:UK'))\`.
      `
  }),
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.standardDeviation.quickFunctionDescription', {
    defaultMessage: 'The standard deviation of the values of a number field which is the amount of variation of the fields values.'
  })
});
exports.standardDeviationOperation = standardDeviationOperation;
const sumOperation = buildMetricOperation({
  type: 'sum',
  priority: 1,
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.sum', {
    defaultMessage: 'Sum'
  }),
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.sumOf', {
    defaultMessage: 'Sum of {name}',
    values: {
      name
    }
  }),
  optionalTimeScaling: true,
  description: _i18n.i18n.translate('xpack.lens.indexPattern.sum.description', {
    defaultMessage: 'A single-value metrics aggregation that sums up numeric values that are extracted from the aggregated documents.'
  }),
  hideZeroOption: true,
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.sum.quickFunctionDescription', {
    defaultMessage: 'The total amount of the values of a number field.'
  })
});
exports.sumOperation = sumOperation;
const medianOperation = buildMetricOperation({
  type: 'median',
  priority: 3,
  displayName: _i18n.i18n.translate('xpack.lens.indexPattern.median', {
    defaultMessage: 'Median'
  }),
  ofName: name => _i18n.i18n.translate('xpack.lens.indexPattern.medianOf', {
    defaultMessage: 'Median of {name}',
    values: {
      name
    }
  }),
  description: _i18n.i18n.translate('xpack.lens.indexPattern.median.description', {
    defaultMessage: 'A single-value metrics aggregation that computes the median value that are extracted from the aggregated documents.'
  }),
  quickFunctionDocumentation: _i18n.i18n.translate('xpack.lens.indexPattern.median.quickFunctionDescription', {
    defaultMessage: 'The median value of a number field.'
  })
});
exports.medianOperation = medianOperation;