"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.combineErrorMessages = combineErrorMessages;
exports.generateMissingFieldMessage = void 0;
exports.getExistsFilter = getExistsFilter;
exports.getFilter = getFilter;
exports.getFormatFromPreviousColumn = getFormatFromPreviousColumn;
exports.getInvalidFieldMessage = getInvalidFieldMessage;
exports.getSafeName = getSafeName;
exports.isColumn = void 0;
exports.isColumnFormatted = isColumnFormatted;
exports.isColumnOfType = isColumnOfType;
exports.isMetricCounterField = isMetricCounterField;
exports.isValidNumber = isValidNumber;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _ = require(".");
var _pure_utils = require("../../pure_utils");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getInvalidFieldMessage(layer, columnId, indexPattern) {
  var _operationDefinition$, _operationDefinition$2;
  if (!indexPattern) {
    return;
  }
  const column = layer.columns[columnId];
  const {
    operationType
  } = column;
  const operationDefinition = operationType ? _.operationDefinitionMap[operationType] : undefined;
  const fieldNames = (0, _pure_utils.hasField)(column) && operationDefinition ? (_operationDefinition$ = operationDefinition === null || operationDefinition === void 0 ? void 0 : (_operationDefinition$2 = operationDefinition.getCurrentFields) === null || _operationDefinition$2 === void 0 ? void 0 : _operationDefinition$2.call(operationDefinition, column)) !== null && _operationDefinition$ !== void 0 ? _operationDefinition$ : [column.sourceField] : [];
  const fields = fieldNames.map(fieldName => indexPattern.getFieldByName(fieldName));
  const filteredFields = fields.filter(Boolean);
  const isInvalid = Boolean(fields.length > filteredFields.length || !((operationDefinition === null || operationDefinition === void 0 ? void 0 : operationDefinition.input) === 'field' && filteredFields.every(field => operationDefinition.getPossibleOperationForField(field) != null)));
  const isWrongType = Boolean(filteredFields.length && !(operationDefinition !== null && operationDefinition !== void 0 && operationDefinition.isTransferable(column, indexPattern, _.operationDefinitionMap)));
  if (isInvalid) {
    // Missing fields have priority over wrong type
    // This has been moved as some transferable checks also perform exist checks internally and fail eventually
    // but that would make type mismatch error appear in place of missing fields scenarios
    const missingFields = fields.map((field, i) => field ? null : fieldNames[i]).filter(Boolean);
    if (missingFields.length) {
      return [generateMissingFieldMessage(missingFields, columnId)];
    }
    if (isWrongType) {
      var _operationDefinition$3, _operationDefinition$4;
      // as fallback show all the fields as invalid?
      const wrongTypeFields = (_operationDefinition$3 = operationDefinition === null || operationDefinition === void 0 ? void 0 : (_operationDefinition$4 = operationDefinition.getNonTransferableFields) === null || _operationDefinition$4 === void 0 ? void 0 : _operationDefinition$4.call(operationDefinition, column, indexPattern)) !== null && _operationDefinition$3 !== void 0 ? _operationDefinition$3 : fieldNames;
      return [_i18n.i18n.translate('xpack.lens.indexPattern.fieldsWrongType', {
        defaultMessage: '{count, plural, one {Field} other {Fields}} {invalidFields} {count, plural, one {is} other {are}} of the wrong type',
        values: {
          count: wrongTypeFields.length,
          invalidFields: wrongTypeFields.join(', ')
        }
      })];
    }
  }
  return undefined;
}
const generateMissingFieldMessage = (missingFields, columnId) => ({
  message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.lens.indexPattern.fieldsNotFound",
    defaultMessage: "{count, plural, one {Field} other {Fields}} {missingFields} {count, plural, one {was} other {were}} not found.",
    values: {
      count: missingFields.length,
      missingFields: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, missingFields.map((field, index) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: field
      }, /*#__PURE__*/_react.default.createElement("strong", null, field), index + 1 === missingFields.length ? '' : ', ')))
    }
  }),
  displayLocations: [{
    id: 'toolbar'
  }, {
    id: 'dimensionButton',
    dimensionId: columnId
  }, {
    id: 'embeddableBadge'
  }]
});
exports.generateMissingFieldMessage = generateMissingFieldMessage;
function combineErrorMessages(errorMessages) {
  const messages = errorMessages.filter(Boolean).flat();
  return messages.length ? messages : undefined;
}
function getSafeName(name, indexPattern) {
  const field = indexPattern === null || indexPattern === void 0 ? void 0 : indexPattern.getFieldByName(name);
  return field ? field.displayName : _i18n.i18n.translate('xpack.lens.indexPattern.missingFieldLabel', {
    defaultMessage: 'Missing field'
  });
}
function isValidNumber(inputValue, integer, upperBound, lowerBound) {
  const inputValueAsNumber = Number(inputValue);
  return inputValue !== '' && inputValue != null && !Number.isNaN(inputValueAsNumber) && Number.isFinite(inputValueAsNumber) && (!integer || Number.isInteger(inputValueAsNumber)) && (upperBound === undefined || inputValueAsNumber <= upperBound) && (lowerBound === undefined || inputValueAsNumber >= lowerBound);
}
function isColumnOfType(type, column) {
  return column.operationType === type;
}
const isColumn = setter => {
  return 'operationType' in setter;
};
exports.isColumn = isColumn;
function isColumnFormatted(column) {
  return Boolean('params' in column && column.params && 'format' in column.params);
}
function getFormatFromPreviousColumn(previousColumn) {
  return (previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.dataType) === 'number' && isColumnFormatted(previousColumn) && previousColumn.params ? {
    format: previousColumn.params.format
  } : undefined;
}
function getExistsFilter(field) {
  return {
    query: `${field}: *`,
    language: 'kuery'
  };
}
function getFilter(previousColumn, columnParams) {
  let filter = previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.filter;
  if (previousColumn && isColumnOfType('last_value', previousColumn) && (0, _lodash.isEqual)(filter, getExistsFilter(previousColumn === null || previousColumn === void 0 ? void 0 : previousColumn.sourceField))) {
    return;
  }
  if (columnParams) {
    if ('kql' in columnParams) {
      var _columnParams$kql;
      filter = {
        query: (_columnParams$kql = columnParams.kql) !== null && _columnParams$kql !== void 0 ? _columnParams$kql : '',
        language: 'kuery'
      };
    } else if ('lucene' in columnParams) {
      var _columnParams$lucene;
      filter = {
        query: (_columnParams$lucene = columnParams.lucene) !== null && _columnParams$lucene !== void 0 ? _columnParams$lucene : '',
        language: 'lucene'
      };
    }
  }
  return filter;
}
function isMetricCounterField(field) {
  return (field === null || field === void 0 ? void 0 : field.timeSeriesMetric) === 'counter';
}