"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatSelector = FormatSelector;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/visualization-ui-components/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/field-formats-plugin/common");
var _i18nReact = require("@kbn/i18n-react");
var _helpers = require("../operations/definitions/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const supportedFormats = {
  number: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.numberFormatLabel', {
      defaultMessage: 'Number'
    }),
    supportsCompact: true
  },
  percent: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.percentFormatLabel', {
      defaultMessage: 'Percent'
    }),
    supportsCompact: true
  },
  bytes: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.bytesFormatLabel', {
      defaultMessage: 'Bytes (1024)'
    }),
    supportsCompact: false
  },
  bits: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.bitsFormatLabel', {
      defaultMessage: 'Bits (1000)'
    }),
    defaultDecimals: 0,
    supportsCompact: false
  },
  custom: {
    title: _i18n.i18n.translate('xpack.lens.indexPattern.customFormatLabel', {
      defaultMessage: 'Custom format'
    }),
    defaultDecimals: 0,
    supportsCompact: false
  }
};
const defaultOption = {
  value: '',
  label: _i18n.i18n.translate('xpack.lens.indexPattern.defaultFormatLabel', {
    defaultMessage: 'Default'
  })
};
const singleSelectionOption = {
  asPlainText: true
};
const label = _i18n.i18n.translate('xpack.lens.indexPattern.columnFormatLabel', {
  defaultMessage: 'Value format'
});
const decimalsLabel = _i18n.i18n.translate('xpack.lens.indexPattern.decimalPlacesLabel', {
  defaultMessage: 'Decimals'
});
const suffixLabel = _i18n.i18n.translate('xpack.lens.indexPattern.suffixLabel', {
  defaultMessage: 'Suffix'
});
const compactLabel = _i18n.i18n.translate('xpack.lens.indexPattern.compactLabel', {
  defaultMessage: 'Compact values'
});
const RANGE_MIN = 0;
const RANGE_MAX = 15;
function useDebouncedInputforParam(name, defaultValue, currentFormat, onChange) {
  var _currentFormat$params;
  const onChangeParam = (0, _react.useCallback)(value => {
    if (!currentFormat) {
      return;
    }
    onChange({
      id: currentFormat.id,
      params: {
        ...currentFormat.params,
        [name]: value
      }
    });
  }, [currentFormat, name, onChange]);
  const {
    handleInputChange: setter,
    inputValue: value
  } = (0, _public.useDebouncedValue)({
    onChange: onChangeParam,
    value: (currentFormat === null || currentFormat === void 0 ? void 0 : (_currentFormat$params = currentFormat.params) === null || _currentFormat$params === void 0 ? void 0 : _currentFormat$params[name]) || defaultValue
  }, {
    allowFalsyValue: true
  });
  return {
    setter,
    value
  };
}
function FormatSelector(props) {
  var _selectedColumn$param, _currentFormat$params2, _currentFormat$params3;
  const {
    uiSettings
  } = (0, _public2.useKibana)().services;
  const {
    selectedColumn,
    onChange
  } = props;
  const currentFormat = (0, _helpers.isColumnFormatted)(selectedColumn) ? (_selectedColumn$param = selectedColumn.params) === null || _selectedColumn$param === void 0 ? void 0 : _selectedColumn$param.format : undefined;
  const [decimals, setDecimals] = (0, _react.useState)((_currentFormat$params2 = currentFormat === null || currentFormat === void 0 ? void 0 : (_currentFormat$params3 = currentFormat.params) === null || _currentFormat$params3 === void 0 ? void 0 : _currentFormat$params3.decimals) !== null && _currentFormat$params2 !== void 0 ? _currentFormat$params2 : 2);
  const {
    setter: setSuffix,
    value: suffix
  } = useDebouncedInputforParam('suffix', '', currentFormat, onChange);
  const {
    setter: setCompact,
    value: compact
  } = useDebouncedInputforParam('compact', false, currentFormat, onChange);
  const defaultNumeralPatternInKibana = uiSettings.get(_common.FORMATS_UI_SETTINGS.FORMAT_NUMBER_DEFAULT_PATTERN);
  const {
    setter: setPattern,
    value: pattern
  } = useDebouncedInputforParam('pattern', defaultNumeralPatternInKibana, currentFormat, onChange);
  const selectedFormat = currentFormat !== null && currentFormat !== void 0 && currentFormat.id ? supportedFormats[currentFormat.id] : undefined;
  const stableOptions = (0, _react.useMemo)(() => [defaultOption, ...Object.entries(supportedFormats).map(([id, format]) => {
    var _format$title;
    return {
      value: id,
      label: (_format$title = format.title) !== null && _format$title !== void 0 ? _format$title : id
    };
  })], []);
  const onChangeWrapped = (0, _react.useCallback)(choices => {
    if (choices.length === 0) {
      return;
    }
    if (!choices[0].value) {
      onChange();
      return;
    }
    const id = choices[0].value;
    const defaultDecimals = supportedFormats[id].defaultDecimals;
    onChange({
      id: choices[0].value,
      params: {
        decimals: defaultDecimals !== null && defaultDecimals !== void 0 ? defaultDecimals : decimals
      }
    });
    setDecimals(defaultDecimals !== null && defaultDecimals !== void 0 ? defaultDecimals : decimals);
  }, [onChange, decimals]);
  const currentOption = (0, _react.useMemo)(() => {
    var _selectedFormat$title;
    return currentFormat ? [{
      value: currentFormat.id,
      label: (_selectedFormat$title = selectedFormat === null || selectedFormat === void 0 ? void 0 : selectedFormat.title) !== null && _selectedFormat$title !== void 0 ? _selectedFormat$title : currentFormat.id
    }] : [defaultOption];
  }, [currentFormat, selectedFormat === null || selectedFormat === void 0 ? void 0 : selectedFormat.title]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    display: "columnCompressed",
    fullWidth: true,
    helpText: (currentFormat === null || currentFormat === void 0 ? void 0 : currentFormat.id) === 'custom' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.lens.indexPattern.customFormat.description",
      defaultMessage: "Numeral.js format pattern (Default: {defaultPattern})",
      values: {
        defaultPattern: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, defaultNumeralPatternInKibana)
      }
    }) : null
  }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    isClearable: false,
    "data-test-subj": "indexPattern-dimension-format",
    "aria-label": label,
    singleSelection: singleSelectionOption,
    options: stableOptions,
    selectedOptions: currentOption,
    onChange: onChangeWrapped
  }), currentFormat && currentFormat.id !== 'custom' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    showInput: "inputWithPopover",
    value: decimals,
    min: RANGE_MIN,
    max: RANGE_MAX,
    onChange: e => {
      const value = Number(e.currentTarget.value);
      setDecimals(value);
      const validatedValue = Math.min(RANGE_MAX, Math.max(RANGE_MIN, value));
      onChange({
        id: currentFormat.id,
        params: {
          ...currentFormat.params,
          decimals: validatedValue
        }
      });
    },
    "data-test-subj": "indexPattern-dimension-formatDecimals",
    compressed: true,
    fullWidth: true,
    prepend: decimalsLabel,
    "aria-label": decimalsLabel
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: suffix,
    onChange: e => {
      setSuffix(e.currentTarget.value);
    },
    "data-test-subj": "indexPattern-dimension-formatSuffix",
    compressed: true,
    fullWidth: true,
    prepend: suffixLabel,
    "aria-label": suffixLabel
  })) : null, selectedFormat !== null && selectedFormat !== void 0 && selectedFormat.supportsCompact ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    label: compactLabel,
    checked: Boolean(compact),
    onChange: () => setCompact(!compact),
    "data-test-subj": "lns-indexpattern-dimension-formatCompact"
  })) : null)), (currentFormat === null || currentFormat === void 0 ? void 0 : currentFormat.id) === 'custom' ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    hasEmptyLabelSpace: true,
    label: " "
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": 'numberEditorFormatPattern',
    prepend: _i18n.i18n.translate('xpack.lens.indexPattern.custom.patternLabel', {
      defaultMessage: 'Format'
    }),
    value: pattern,
    placeholder: defaultNumeralPatternInKibana,
    onChange: e => {
      setPattern(e.target.value);
    }
  })) : null);
}