"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStyles = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStyles = depth => {
  const {
    euiTheme
  } = (0, _hooks.useEuiTheme)();
  const cached = (0, _react.useMemo)(() => {
    const {
      size,
      colors
    } = euiTheme;
    const loadMoreButtonWrapper = {
      position: 'relative',
      textAlign: 'center',
      width: `calc(100% + ${depth * 24}px)`,
      marginLeft: `-${depth * 24}px`,
      '&:after': {
        content: `''`,
        position: 'absolute',
        top: '50%',
        width: '100%',
        border: `1px dashed ${colors.mediumShade}`,
        left: 0
      }
    };
    const loadMoreButton = {
      position: 'relative',
      cursor: 'pointer',
      zIndex: 2
    };
    const loadMoreText = {
      marginRight: size.s
    };
    const loadMoreTextLeft = {
      marginLeft: size.s
    };
    const leafNodeButton = {
      marginLeft: size.l,
      width: `calc(100% - ${size.l})`,
      paddingLeft: 0
    };
    const labelIcon = {
      marginRight: size.s,
      marginLeft: size.s
    };
    const treeViewWrapper = expanded => ({
      display: !expanded ? 'none' : 'inherit',
      '.euiTreeView__node--selected > .euiTreeView__nodeInner': {
        backgroundColor: (0, _eui.transparentize)(colors.darkestShade, 0.1)
      },
      '.euiTreeView__node--expanded': {
        maxHeight: '100%'
      },
      '.euiTreeView__nodeInner .euiToolTipAnchor': {
        maxWidth: '100%',
        overflow: 'hidden',
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
        wordWrap: 'normal'
      }
    });
    return {
      loadMoreButton,
      loadMoreButtonWrapper,
      loadMoreText,
      loadMoreTextLeft,
      leafNodeButton,
      labelIcon,
      treeViewWrapper
    };
  }, [euiTheme, depth]);
  return cached;
};
exports.useStyles = useStyles;