"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DynamicTreeView = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _translations = require("../../../../common/translations");
var _hooks = require("./hooks");
var _styles = require("./styles");
var _helpers = require("./helpers");
var _contexts = require("../contexts");
var _tree_view_icon = require("../tree_view_icon");
var _translations2 = require("../translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BUTTON_TEST_ID = 'kubernetesSecurity:dynamicTreeViewButton';
const focusNextButton = event => {
  (0, _helpers.focusNextElement)(event, `[data-test-subj="${BUTTON_TEST_ID}"]`, 'next');
};
const focusPreviousButton = event => {
  (0, _helpers.focusNextElement)(event, `[data-test-subj="${BUTTON_TEST_ID}"]`, 'prev');
};
const DynamicTreeViewExpander = ({
  defaultExpanded = false,
  children
}) => {
  const [isExpanded, setIsExpanded] = (0, _react.useState)(defaultExpanded);
  const onToggleExpand = () => {
    setIsExpanded(e => !e);
  };
  return children({
    isExpanded,
    onToggleExpand
  });
};
const DynamicTreeView = ({
  tree,
  depth = 0,
  selectionDepth = {},
  query,
  onSelect,
  selected = '',
  expanded = true,
  ...props
}) => {
  var _data$pages4;
  const styles = (0, _styles.useStyles)(depth);
  const {
    indexPattern,
    setNoResults,
    setTreeNavSelection
  } = (0, _contexts.useTreeViewContext)();
  const {
    data,
    fetchNextPage,
    isFetchingNextPage,
    hasNextPage,
    isLoading
  } = (0, _hooks.useFetchDynamicTreeView)(query, tree[depth].key, indexPattern, expanded);
  const ariaLabel = props['aria-label'];
  const onLoadMoreKeydown = event => {
    switch (event.key) {
      case _eui.keys.ARROW_DOWN:
        {
          focusNextButton(event);
          break;
        }
      case _eui.keys.ARROW_UP:
        {
          focusPreviousButton(event);
          break;
        }
      case _eui.keys.ARROW_RIGHT:
        {
          (0, _helpers.disableEventDefaults)(event);
          fetchNextPage();
        }
    }
  };
  (0, _react.useEffect)(() => {
    if (depth === 0 && data) {
      var _data$pages;
      const noData = ((_data$pages = data.pages) === null || _data$pages === void 0 ? void 0 : _data$pages[0].buckets.length) === 0;
      setNoResults(noData);
      if (noData) {
        setTreeNavSelection({});
      }
    }
  }, [data, depth, setNoResults, setTreeNavSelection]);
  (0, _react.useEffect)(() => {
    if (expanded) {
      fetchNextPage();
    }
  }, [fetchNextPage, expanded]);
  (0, _react.useEffect)(() => {
    var _data$pages2, _data$pages2$0$bucket, _data$pages2$0$bucket2;
    if (!selected && !depth && data && (_data$pages2 = data.pages) !== null && _data$pages2 !== void 0 && (_data$pages2$0$bucket = _data$pages2[0].buckets) !== null && _data$pages2$0$bucket !== void 0 && (_data$pages2$0$bucket2 = _data$pages2$0$bucket[0]) !== null && _data$pages2$0$bucket2 !== void 0 && _data$pages2$0$bucket2.key) {
      onSelect({}, tree[depth].type, data.pages[0].buckets[0].key, data.pages[0].buckets[0].key_as_string);
    }
  }, [data, depth, selected, onSelect, tree]);
  const onClickNextPageHandler = () => {
    fetchNextPage();
  };
  const itemList = (0, _react.useMemo)(() => {
    var _data$pages3;
    return (data === null || data === void 0 ? void 0 : (_data$pages3 = data.pages) === null || _data$pages3 === void 0 ? void 0 : _data$pages3.map(aggsData => {
      return aggsData === null || aggsData === void 0 ? void 0 : aggsData.buckets;
    }).flat()) || [];
  }, [data === null || data === void 0 ? void 0 : data.pages]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: `euiTreeView__wrapper ${!expanded ? 'euiTreeView__wrapper--hidden' : ''}`,
    css: styles.treeViewWrapper(expanded)
  }, isLoading && /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("span", {
    css: styles.loadMoreTextLeft
  }, _translations.TREE_NAVIGATION_LOADING)), depth === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiI18n, {
    token: "euiTreeView.listNavigationInstructions",
    default: "You can quickly navigate this list using arrow keys."
  }, listNavigationInstructions => /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
    id: "dynamicTreeViewInstructionId"
  }, listNavigationInstructions))), /*#__PURE__*/_react.default.createElement("ul", {
    className: "euiTreeView",
    "aria-describedby": data !== null && data !== void 0 && (_data$pages4 = data.pages) !== null && _data$pages4 !== void 0 && _data$pages4.length ? 'dynamicTreeViewInstructionId' : undefined,
    "aria-label": ariaLabel
  }, itemList.map(aggData => {
    const queryFilter = {
      ...query,
      bool: {
        ...query.bool,
        filter: [...query.bool.filter, {
          term: {
            [tree[depth].key]: aggData.key
          }
        }]
      }
    };
    const defaultExpanded = selected.indexOf('' + aggData.key) > 0;
    return /*#__PURE__*/_react.default.createElement(DynamicTreeViewExpander, {
      key: aggData.key,
      defaultExpanded: defaultExpanded
    }, ({
      isExpanded,
      onToggleExpand
    }) => /*#__PURE__*/_react.default.createElement(DynamicTreeViewItem, {
      aggData: aggData,
      "aria-label": ariaLabel,
      depth: depth,
      expanded: expanded,
      isExpanded: isExpanded,
      onSelect: onSelect,
      onToggleExpand: onToggleExpand,
      query: queryFilter,
      selected: selected,
      selectionDepth: selectionDepth,
      tree: tree
    }));
  }), hasNextPage && /*#__PURE__*/_react.default.createElement("li", {
    key: "load_more",
    className: "euiTreeView__node",
    css: styles.loadMoreButtonWrapper
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: styles.loadMoreButton,
    onClickAriaLabel: (0, _translations.TREE_NAVIGATION_SHOW_MORE)(tree[depth].namePlural),
    "data-test-subj": BUTTON_TEST_ID,
    onKeyDown: event => onLoadMoreKeydown(event),
    onClick: onClickNextPageHandler
  }, /*#__PURE__*/_react.default.createElement("span", {
    css: styles.loadMoreText
  }, isFetchingNextPage ? _translations.TREE_NAVIGATION_LOADING : (0, _translations.TREE_NAVIGATION_SHOW_MORE)(tree[depth].namePlural)), isFetchingNextPage ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: "arrowDown"
  })))));
};
exports.DynamicTreeView = DynamicTreeView;
const DynamicTreeViewItem = ({
  depth,
  tree,
  onToggleExpand,
  onSelect,
  aggData,
  selectionDepth,
  isExpanded,
  selected,
  expanded,
  query,
  ...props
}) => {
  const isLastNode = depth === tree.length - 1;
  const styles = (0, _styles.useStyles)(depth);
  const buttonRef = (0, _react.useRef)({});
  const handleSelect = () => {
    if (tree[depth].type === 'clusterId') {
      onSelect(selectionDepth, tree[depth].type, aggData.key, aggData.key_as_string);
    } else {
      onSelect(selectionDepth, tree[depth].type, aggData.key);
    }
  };
  const onKeyboardToggle = () => {
    if (!isLastNode) {
      onToggleExpand();
    }
    handleSelect();
  };
  const onButtonToggle = () => {
    if (!isLastNode && !isExpanded) {
      onToggleExpand();
    }
    handleSelect();
  };
  const onArrowToggle = event => {
    (0, _helpers.disableEventDefaults)(event);
    if (!isLastNode) {
      onToggleExpand();
    }
  };

  // Enable keyboard navigation
  const onKeyDown = event => {
    switch (event.key) {
      case _eui.keys.ARROW_DOWN:
        {
          focusNextButton(event);
          break;
        }
      case _eui.keys.ARROW_UP:
        {
          focusPreviousButton(event);
          break;
        }
      case _eui.keys.ARROW_RIGHT:
        {
          if (!isExpanded && !isLastNode) {
            (0, _helpers.disableEventDefaults)(event);
            onKeyboardToggle();
          }
          break;
        }
      case _eui.keys.ARROW_LEFT:
        {
          if (isExpanded) {
            (0, _helpers.disableEventDefaults)(event);
            onKeyboardToggle();
          }
        }
      default:
        break;
    }
  };
  const onChildrenKeydown = (event, key) => {
    if (event.key === _eui.keys.ARROW_LEFT) {
      (0, _helpers.disableEventDefaults)(event);
      buttonRef.current[key].focus();
    }
  };
  const isSelected = (0, _react.useMemo)(() => {
    return selected === Object.entries({
      ...selectionDepth,
      [tree[depth].type]: aggData.key,
      ...(tree[depth].type === 'clusterId' && aggData.key_as_string && {
        clusterName: aggData.key_as_string
      })
    }).map(([k, v]) => `${k}.${v}`).join();
  }, [aggData.key, aggData.key_as_string, depth, selected, selectionDepth, tree]);
  const clusterLevel = _translations2.BREADCRUMBS_CLUSTER_TREE_VIEW_LEVELS[tree[depth].type];
  return /*#__PURE__*/_react.default.createElement("li", {
    className: `euiTreeView__node
        ${isExpanded ? 'euiTreeView__node--expanded' : ''}
        ${isSelected ? 'euiTreeView__node--selected' : ''}
      `
  }, /*#__PURE__*/_react.default.createElement("button", {
    "data-test-subj": expanded ? BUTTON_TEST_ID : '',
    className: "euiTreeView__nodeInner euiTreeView__nodeInner--withArrows",
    onClick: onButtonToggle,
    onKeyDown: onKeyDown,
    ref: el => buttonRef.current[aggData.key] = el,
    css: isLastNode ? styles.leafNodeButton : undefined
  }, !isLastNode && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    className: "euiTreeView__expansionArrow",
    type: isExpanded ? 'arrowDown' : 'arrowRight',
    onClick: onArrowToggle
  }), /*#__PURE__*/_react.default.createElement(_tree_view_icon.TreeViewIcon, (0, _extends2.default)({}, tree[depth].iconProps, {
    css: styles.labelIcon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: `${clusterLevel}: ${aggData.key}`
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "euiTreeView__nodeLabel"
  }, aggData.key_as_string || aggData.key))), /*#__PURE__*/_react.default.createElement("div", {
    onKeyDown: event => onChildrenKeydown(event, aggData.key.toString())
  }, !isLastNode && /*#__PURE__*/_react.default.createElement(DynamicTreeView, {
    expanded: isExpanded,
    query: query,
    depth: depth + 1,
    selectionDepth: {
      ...selectionDepth,
      [tree[depth].type]: aggData.key,
      ...(tree[depth].type === 'clusterId' && {
        clusterName: aggData.key_as_string
      })
    },
    tree: tree,
    onSelect: onSelect,
    selected: selected,
    "aria-label": `${aggData.key} child of ${props['aria-label']}`
  })));
};