"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlTemplateEditor = void 0;
var React = _interopRequireWildcard(require("react"));
var _monaco = require("@kbn/monaco");
var _code_editor = require("../code_editor");
require("./styles.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const UrlTemplateEditor = ({
  height = 105,
  value,
  variables,
  onChange,
  placeholder,
  onEditor,
  Editor = _code_editor.CodeEditor
}) => {
  const refEditor = React.useRef(null);
  const handleEditor = React.useCallback(editor => {
    refEditor.current = editor;
    if (onEditor) {
      onEditor(editor);
    }
  }, []);
  const handleKeyDown = React.useCallback(event => {
    const editor = refEditor.current;
    if (!editor) return;
    if (event.key === 'Escape') {
      if (editor.hasWidgetFocus()) {
        // Don't propagate Escape click if Monaco editor is focused, this allows
        // user to close the autocomplete widget with Escape button without
        // closing the EUI flyout.
        event.stopPropagation();
        editor.trigger('editor', 'hideSuggestWidget', []);
      }
    }
  }, []);
  React.useEffect(() => {
    if (!variables) {
      return;
    }
    const {
      dispose
    } = _monaco.monaco.languages.registerCompletionItemProvider(_code_editor.HandlebarsLang, {
      triggerCharacters: ['{', '/', '?', '&', '='],
      provideCompletionItems(model, position, context, token) {
        const {
          lineNumber
        } = position;
        const line = model.getLineContent(lineNumber);
        const wordUntil = model.getWordUntilPosition(position);
        const word = model.getWordAtPosition(position) || wordUntil;
        const {
          startColumn,
          endColumn
        } = word;
        const range = {
          startLineNumber: lineNumber,
          endLineNumber: lineNumber,
          startColumn,
          endColumn
        };
        const leadingMustacheCount = 0 + (line[range.startColumn - 2] === '{' ? 1 : 0) + (line[range.startColumn - 3] === '{' ? 1 : 0);
        const trailingMustacheCount = 0 + (line[range.endColumn - 1] === '}' ? 1 : 0) + (line[range.endColumn + 0] === '}' ? 1 : 0);
        return {
          suggestions: variables.map(({
            label,
            title = '',
            documentation = '',
            kind = _monaco.monaco.languages.CompletionItemKind.Variable,
            sortText
          }) => ({
            kind,
            label,
            insertText: (leadingMustacheCount === 2 ? '' : leadingMustacheCount === 1 ? '{' : '{{') + label + (trailingMustacheCount === 2 ? '' : trailingMustacheCount === 1 ? '}' : '}}'),
            detail: title,
            documentation,
            range,
            sortText
          }))
        };
      }
    });
    return () => {
      dispose();
    };
  }, [variables]);
  return /*#__PURE__*/React.createElement("div", {
    className: 'urlTemplateEditor__container',
    onKeyDown: handleKeyDown
  }, /*#__PURE__*/React.createElement(Editor, {
    languageId: _code_editor.HandlebarsLang,
    height: height,
    value: value,
    onChange: onChange,
    editorDidMount: handleEditor,
    placeholder: placeholder,
    options: {
      fontSize: 14,
      highlightActiveIndentGuide: false,
      renderLineHighlight: 'none',
      lineNumbers: 'off',
      glyphMargin: false,
      folding: false,
      lineDecorationsWidth: 2,
      quickSuggestions: {
        comments: false,
        strings: false,
        other: false
      },
      suggestOnTriggerCharacters: true,
      minimap: {
        enabled: false
      },
      wordWrap: 'on',
      wrappingIndent: 'none'
    }
  }));
};
exports.UrlTemplateEditor = UrlTemplateEditor;