"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaTheme = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _rxjs = require("rxjs");
var _context = require("../context/context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const useKibanaTheme = () => {
  const defaultTheme = {
    darkMode: false
  };
  const {
    services: {
      theme
    }
  } = (0, _context.useKibana)();
  let themeObservable;
  if (!theme) {
    themeObservable = (0, _rxjs.of)(defaultTheme);
  } else {
    themeObservable = theme.theme$;
  }
  return (0, _useObservable.default)(themeObservable, defaultTheme);
};
exports.useKibanaTheme = useKibanaTheme;