"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KibanaPageTemplateSolutionNavCollapseButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
require("./solution_nav_collapse_button.scss");
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Creates the styled icon button for showing/hiding solution nav
 */
const KibanaPageTemplateSolutionNavCollapseButton = ({
  className,
  isCollapsed,
  ...rest
}) => {
  const classes = (0, _classnames.default)('kbnPageTemplateSolutionNavCollapseButton', {
    'kbnPageTemplateSolutionNavCollapseButton-isCollapsed': isCollapsed
  }, className);
  const collapseLabel = _i18n.i18n.translate('kibana-react.solutionNav.collapsibleLabel', {
    defaultMessage: 'Collapse side navigation'
  });
  const openLabel = _i18n.i18n.translate('kibana-react.solutionNav.openLabel', {
    defaultMessage: 'Open side navigation'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
    className: classes,
    size: "s",
    color: "text",
    iconType: isCollapsed ? 'menuRight' : 'menuLeft',
    "aria-label": isCollapsed ? openLabel : collapseLabel,
    title: isCollapsed ? openLabel : collapseLabel
  }, rest));
};
exports.KibanaPageTemplateSolutionNavCollapseButton = KibanaPageTemplateSolutionNavCollapseButton;