"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoDataConfigPageWithSolutionNavBar = exports.NoDataConfigPage = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _no_data_page = require("../no_data_page");
var _with_solution_nav = require("../../with_solution_nav");
var _util = require("../../util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const NoDataConfigPage = props => {
  const {
    className,
    noDataConfig,
    ...rest
  } = props;
  if (!noDataConfig) {
    return null;
  }
  const template = _util.NO_DATA_PAGE_TEMPLATE_PROPS.template;
  const classes = (0, _util.getClasses)(template, className);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate_Deprecated, (0, _extends2.default)({
    "data-test-subj": props['data-test-subj'],
    template: template,
    className: classes
  }, rest, _util.NO_DATA_PAGE_TEMPLATE_PROPS), /*#__PURE__*/_react.default.createElement(_no_data_page.NoDataPage, noDataConfig));
};
exports.NoDataConfigPage = NoDataConfigPage;
const NoDataConfigPageWithSolutionNavBar = (0, _with_solution_nav.withSolutionNav)(NoDataConfigPage);
exports.NoDataConfigPageWithSolutionNavBar = NoDataConfigPageWithSolutionNavBar;