"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExitFullScreenButton = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
require("./index.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ExitFullScreenButtonUi extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "onKeyDown", e => {
      if (e.key === _eui.keys.ESCAPE) {
        this.props.onExitFullScreenMode();
      }
    });
  }
  componentDidMount() {
    if (this.props.toggleChrome) this.props.chrome.setIsVisible(false);
    document.addEventListener('keydown', this.onKeyDown, false);
  }
  componentWillUnmount() {
    if (this.props.toggleChrome) this.props.chrome.setIsVisible(true);
    document.removeEventListener('keydown', this.onKeyDown, false);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
      "aria-live": "polite"
    }, _i18n.i18n.translate('kibana-react.exitFullScreenButton.fullScreenModeDescription', {
      defaultMessage: 'In full screen mode, press ESC to exit.'
    }))), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("button", {
      "aria-label": _i18n.i18n.translate('kibana-react.exitFullScreenButton.exitFullScreenModeButtonAriaLabel', {
        defaultMessage: 'Exit full screen mode'
      }),
      className: "dshExitFullScreenButton",
      onClick: this.props.onExitFullScreenMode,
      "data-test-subj": "exitFullScreenModeLogo"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      component: "span",
      responsive: false,
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "logoElastic",
      size: "l"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "exitFullScreenModeText"
    }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: "dshExitFullScreenButton__text"
    }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('kibana-react.exitFullScreenButton.exitFullScreenModeButtonText', {
      defaultMessage: 'Exit full screen'
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "fullScreen",
      className: "dshExitFullScreenButton__icon"
    }))))));
  }
}

/** @deprecated Use `ExitFullScreenButton` from `@kbn/shared-ux-button-exit-full-screen`. */
(0, _defineProperty2.default)(ExitFullScreenButtonUi, "defaultProps", {
  toggleChrome: true
});
const ExitFullScreenButton = ExitFullScreenButtonUi;
exports.ExitFullScreenButton = ExitFullScreenButton;